@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property allowInterrupt Whether the user can interrupt a speech prompt attempt from the bot.
 * @property allowedInputTypes Configuration block for the allowed input types of the prompt attempt. See `allowed_input_types`.
 * @property audioAndDtmfInputSpecification Configuration block for settings on audio and DTMF input. See `audio_and_dtmf_input_specification`.
 * @property mapBlockKey Which attempt to configure. Valid values are `Initial`, `Retry1`, `Retry2`, `Retry3`, `Retry4`, `Retry5`.
 * @property textInputSpecification Configuration block for the settings on text input. See `text_input_specification`.
 */
public data class V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecification(
    public val allowInterrupt: Boolean? = null,
    public val allowedInputTypes: V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAllowedInputTypes,
    public val audioAndDtmfInputSpecification: V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecification? =
        null,
    public val mapBlockKey: String,
    public val textInputSpecification: V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationTextInputSpecification? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecification): V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecification =
            V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecification(
                allowInterrupt = javaType.allowInterrupt().map({ args0 -> args0 }).orElse(null),
                allowedInputTypes = javaType.allowedInputTypes().let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAllowedInputTypes.Companion.toKotlin(args0)
                }),
                audioAndDtmfInputSpecification = javaType.audioAndDtmfInputSpecification().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecification.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                mapBlockKey = javaType.mapBlockKey(),
                textInputSpecification = javaType.textInputSpecification().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationTextInputSpecification.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
