@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deletionCharacter DTMF character that clears the accumulated DTMF digits and immediately ends the input.
 * @property endCharacter DTMF character that immediately ends input. If the user does not press this character, the input ends after the end timeout.
 * @property endTimeoutMs How long the bot should wait after the last DTMF character input before assuming that the input has concluded.
 * @property maxLength Maximum number of DTMF digits allowed in an utterance.
 */
public data class
V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationDtmfSpecification(
    public val deletionCharacter: String,
    public val endCharacter: String,
    public val endTimeoutMs: Int,
    public val maxLength: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationDtmfSpecification): V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationDtmfSpecification =
            V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecificationAudioAndDtmfInputSpecificationDtmfSpecification(
                deletionCharacter = javaType.deletionCharacter(),
                endCharacter = javaType.endCharacter(),
                endTimeoutMs = javaType.endTimeoutMs(),
                maxLength = javaType.maxLength(),
            )
    }
}
