@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property active Whether the fulfillment code hook is used. When active is false, the code hook doesn't run.
 * @property enabled Whether a Lambda function should be invoked to fulfill a specific intent.
 * @property fulfillmentUpdatesSpecification Configuration block for settings for update messages sent to the user for long-running Lambda fulfillment functions. Fulfillment updates can be used only with streaming conversations. See `fulfillment_updates_specification`.
 * @property postFulfillmentStatusSpecification Configuration block for settings for messages sent to the user for after the Lambda fulfillment function completes. Post-fulfillment messages can be sent for both streaming and non-streaming conversations. See `post_fulfillment_status_specification`.
 */
public data class V2modelsIntentFulfillmentCodeHook(
    public val active: Boolean? = null,
    public val enabled: Boolean,
    public val fulfillmentUpdatesSpecification: V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecification? = null,
    public val postFulfillmentStatusSpecification: V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecification? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsIntentFulfillmentCodeHook): V2modelsIntentFulfillmentCodeHook = V2modelsIntentFulfillmentCodeHook(
            active = javaType.active().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled(),
            fulfillmentUpdatesSpecification = javaType.fulfillmentUpdatesSpecification().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecification.Companion.toKotlin(args0)
                })
            }).orElse(null),
            postFulfillmentStatusSpecification = javaType.postFulfillmentStatusSpecification().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecification.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
