@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property active Whether fulfillment updates are sent to the user. When this field is true, updates are sent. If the active field is set to true, the `start_response`, `update_response`, and `timeout_in_seconds` fields are required.
 * @property startResponse Configuration block for the message sent to users when the fulfillment Lambda functions starts running.
 * @property timeoutInSeconds Length of time that the fulfillment Lambda function should run before it times out.
 * @property updateResponse Configuration block for messages sent periodically to the user while the fulfillment Lambda function is running.
 */
public data class V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecification(
    public val active: Boolean,
    public val startResponse: V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponse? = null,
    public val timeoutInSeconds: Int? = null,
    public val updateResponse: V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationUpdateResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecification): V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecification =
            V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecification(
                active = javaType.active(),
                startResponse = javaType.startResponse().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                timeoutInSeconds = javaType.timeoutInSeconds().map({ args0 -> args0 }).orElse(null),
                updateResponse = javaType.updateResponse().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationUpdateResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
