@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allowInterrupt Whether the user can interrupt the start message while it is playing.
 * @property delayInSeconds Delay between when the Lambda fulfillment function starts running and the start message is played. If the Lambda function returns before the delay is over, the start message isn't played.
 * @property messageGroups Between 1-5 configuration block message groups that contain start messages. Amazon Lex chooses one of the messages to play to the user. See `message_group`.
 */
public data class V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponse(
    public val allowInterrupt: Boolean? = null,
    public val delayInSeconds: Int? = null,
    public val messageGroups: List<V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseMessageGroup>? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponse): V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponse =
            V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponse(
                allowInterrupt = javaType.allowInterrupt().map({ args0 -> args0 }).orElse(null),
                delayInSeconds = javaType.delayInSeconds().map({ args0 -> args0 }).orElse(null),
                messageGroups = javaType.messageGroups().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationStartResponseMessageGroup.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
