@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allowInterrupt Whether the user can interrupt the start message while it is playing.
 * @property frequencyInSeconds Frequency that a message is sent to the user. When the period ends, Amazon Lex chooses a message from the message groups and plays it to the user. If the fulfillment Lambda returns before the first period ends, an update message is not played to the user.
 * @property messageGroups Between 1-5 configuration block message groups that contain start messages. Amazon Lex chooses one of the messages to play to the user. See `message_group`.
 */
public data class V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationUpdateResponse(
    public val allowInterrupt: Boolean? = null,
    public val frequencyInSeconds: Int,
    public val messageGroups: List<V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationUpdateResponseMessageGroup>? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationUpdateResponse): V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationUpdateResponse =
            V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationUpdateResponse(
                allowInterrupt = javaType.allowInterrupt().map({ args0 -> args0 }).orElse(null),
                frequencyInSeconds = javaType.frequencyInSeconds(),
                messageGroups = javaType.messageGroups().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentFulfillmentCodeHookFulfillmentUpdatesSpecificationUpdateResponseMessageGroup.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
