@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property active Whether a conditional branch is active. When active is false, the conditions are not evaluated.
 * @property conditionalBranches Configuration blocks for conditional branches. A conditional branch is made up of a condition, a response and a next step. The response and next step are executed when the condition is true. See `conditional_branch`.
 * @property defaultBranch Configuration block for the conditional branch that should be followed when the conditions for other branches are not satisfied. A branch is made up of a condition, a response and a next step. See `default_branch`.
 */
public data class
V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessConditional(
    public val active: Boolean,
    public val conditionalBranches: List<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessConditionalConditionalBranch>? =
        null,
    public val defaultBranch: V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessConditionalDefaultBranch,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessConditional): V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessConditional =
            V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessConditional(
                active = javaType.active(),
                conditionalBranches = javaType.conditionalBranches().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessConditionalConditionalBranch.Companion.toKotlin(args0)
                    })
                }),
                defaultBranch = javaType.defaultBranch().let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessConditionalDefaultBranch.Companion.toKotlin(args0)
                }),
            )
    }
}
