@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property dialogAction Configuration block for action that the bot executes at runtime when the conversation reaches this step. See `dialog_action`.
 * @property intent Configuration block for override settings to configure the intent state. See `intent`.
 * @property sessionAttributes Map of key/value pairs representing session-specific context information. It contains application information passed between Amazon Lex and a client application.
 */
public data class
V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStep(
    public val dialogAction: V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepDialogAction? =
        null,
    public val intent: V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepIntent? =
        null,
    public val sessionAttributes: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStep): V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStep =
            V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStep(
                dialogAction = javaType.dialogAction().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepDialogAction.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                intent = javaType.intent().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessNextStepIntent.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                sessionAttributes = javaType.sessionAttributes().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
