@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allowInterrupt Whether the user can interrupt a speech response from Amazon Lex.
 * @property messageGroups Configuration blocks for responses that Amazon Lex can send to the user. Amazon Lex chooses the actual response to send at runtime. See `message_group`.
 */
public data class
V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessResponse(
    public val allowInterrupt: Boolean? = null,
    public val messageGroups: List<V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessResponseMessageGroup>? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessResponse): V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessResponse =
            V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessResponse(
                allowInterrupt = javaType.allowInterrupt().map({ args0 -> args0 }).orElse(null),
                messageGroups = javaType.messageGroups().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentFulfillmentCodeHookPostFulfillmentStatusSpecificationSuccessResponseMessageGroup.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
