@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property codeHook Configuration block for the dialog code hook that is called by Amazon Lex at a step of the conversation. See `code_hook`.
 * @property conditional Configuration block for conditional branches. Branches are evaluated in the order that they are entered in the list. The first branch with a condition that evaluates to true is executed. The last branch in the list is the default branch. The default branch should not have any condition expression. The default branch is executed if no other branch has a matching condition. See `conditional`.
 * @property initialResponse Configuration block for message groups that Amazon Lex uses to respond the user input. See `initial_response`.
 * @property nextStep Configuration block for the next step in the conversation. See `next_step`.
 */
public data class V2modelsIntentInitialResponseSetting(
    public val codeHook: V2modelsIntentInitialResponseSettingCodeHook? = null,
    public val conditional: V2modelsIntentInitialResponseSettingConditional? = null,
    public val initialResponse: V2modelsIntentInitialResponseSettingInitialResponse? = null,
    public val nextStep: V2modelsIntentInitialResponseSettingNextStep? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsIntentInitialResponseSetting): V2modelsIntentInitialResponseSetting = V2modelsIntentInitialResponseSetting(
            codeHook = javaType.codeHook().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentInitialResponseSettingCodeHook.Companion.toKotlin(args0)
                })
            }).orElse(null),
            conditional = javaType.conditional().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentInitialResponseSettingConditional.Companion.toKotlin(args0)
                })
            }).orElse(null),
            initialResponse = javaType.initialResponse().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentInitialResponseSettingInitialResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            nextStep = javaType.nextStep().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentInitialResponseSettingNextStep.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
