@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property failureConditional Configuration block for conditional branches to evaluate after the dialog code hook throws an exception or returns with the State field of the Intent object set to Failed.
 * @property failureNextStep Configuration block for the next step the bot runs after the dialog code hook throws an exception or returns with the State field of the Intent object set to Failed . See `failure_next_step`.
 * @property failureResponse Configuration block for message groups that Amazon Lex uses to respond the user input. See `failure_response`.
 * @property successConditional Configuration block for conditional branches to evaluate after the dialog code hook finishes successfully. See `success_conditional`.
 * @property successNextStep Configuration block for the next step the bot runs after the dialog code hook finishes successfully. See `success_next_step`.
 * @property successResponse Configuration block for message groups that Amazon Lex uses to respond the user input. See `success_response`.
 * @property timeoutConditional Configuration block for conditional branches to evaluate if the code hook times out. See `timeout_conditional`.
 * @property timeoutNextStep Configuration block for the next step that the bot runs when the code hook times out. See `timeout_next_step`.
 * @property timeoutResponse Configuration block for a list of message groups that Amazon Lex uses to respond the user input. See `timeout_response`.
 */
public data class V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecification(
    public val failureConditional: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditional? =
        null,
    public val failureNextStep: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureNextStep? = null,
    public val failureResponse: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureResponse? = null,
    public val successConditional: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditional? =
        null,
    public val successNextStep: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessNextStep? = null,
    public val successResponse: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessResponse? = null,
    public val timeoutConditional: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditional? =
        null,
    public val timeoutNextStep: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutNextStep? = null,
    public val timeoutResponse: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecification): V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecification =
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecification(
                failureConditional = javaType.failureConditional().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureConditional.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                failureNextStep = javaType.failureNextStep().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureNextStep.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                failureResponse = javaType.failureResponse().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationFailureResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                successConditional = javaType.successConditional().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditional.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                successNextStep = javaType.successNextStep().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessNextStep.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                successResponse = javaType.successResponse().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                timeoutConditional = javaType.timeoutConditional().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditional.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                timeoutNextStep = javaType.timeoutNextStep().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutNextStep.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                timeoutResponse = javaType.timeoutResponse().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
