@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kendraIndex ARN of the Amazon Kendra index that you want the AMAZON.KendraSearchIntent intent to search. The index must be in the same account and Region as the Amazon Lex bot.
 * @property queryFilterString Query filter that Amazon Lex sends to Amazon Kendra to filter the response from a query. The filter is in the format defined by Amazon Kendra. For more information, see [Filtering queries](https://docs.aws.amazon.com/kendra/latest/dg/filtering.html).
 * @property queryFilterStringEnabled Whether the AMAZON.KendraSearchIntent intent uses a custom query string to query the Amazon Kendra index.
 */
public data class V2modelsIntentKendraConfiguration(
    public val kendraIndex: String,
    public val queryFilterString: String? = null,
    public val queryFilterStringEnabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsIntentKendraConfiguration): V2modelsIntentKendraConfiguration = V2modelsIntentKendraConfiguration(
            kendraIndex = javaType.kendraIndex(),
            queryFilterString = javaType.queryFilterString().map({ args0 -> args0 }).orElse(null),
            queryFilterStringEnabled = javaType.queryFilterStringEnabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
