@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name Name of the output context.
 * @property timeToLiveInSeconds Amount of time, in seconds, that the output context should remain active. The time is figured from the first time the context is sent to the user.
 * @property turnsToLive Number of conversation turns that the output context should remain active. The number of turns is counted from the first time that the context is sent to the user.
 */
public data class V2modelsIntentOutputContext(
    public val name: String,
    public val timeToLiveInSeconds: Int,
    public val turnsToLive: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsIntentOutputContext): V2modelsIntentOutputContext = V2modelsIntentOutputContext(
            name = javaType.name(),
            timeToLiveInSeconds = javaType.timeToLiveInSeconds(),
            turnsToLive = javaType.turnsToLive(),
        )
    }
}
