@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property allowMultipleValues Whether a slot can return multiple values. When `true`, the slot may return more than one value in a response. When `false`, the slot returns only a single value. Multi-value slots are only available in the `en-US` locale.
 */
public data class V2modelsSlotMultipleValuesSetting(
    public val allowMultipleValues: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsSlotMultipleValuesSetting): V2modelsSlotMultipleValuesSetting = V2modelsSlotMultipleValuesSetting(
            allowMultipleValues = javaType.allowMultipleValues().map({ args0 -> args0 }).orElse(null),
        )
    }
}
