@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property mapBlockKey
 * @property slotTypeId Unique identifier for the slot type associated with this slot.
 * @property valueElicitationSettings Prompts that Amazon Lex sends to the user to elicit a response that provides the value for the slot.
 * The following arguments are optional:
 */
public data class V2modelsSlotSubSlotSettingSlotSpecification(
    public val mapBlockKey: String,
    public val slotTypeId: String,
    public val valueElicitationSettings: List<V2modelsSlotSubSlotSettingSlotSpecificationValueElicitationSetting>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsSlotSubSlotSettingSlotSpecification): V2modelsSlotSubSlotSettingSlotSpecification = V2modelsSlotSubSlotSettingSlotSpecification(
            mapBlockKey = javaType.mapBlockKey(),
            slotTypeId = javaType.slotTypeId(),
            valueElicitationSettings = javaType.valueElicitationSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.V2modelsSlotSubSlotSettingSlotSpecificationValueElicitationSetting.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
