@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kmsKeyArn KMS key required to decrypt the contents of the grammar, if any.
 * @property s3BucketName Name of the Amazon S3 bucket that contains the grammar source.
 * @property s3ObjectKey Path to the grammar in the Amazon S3 bucket.
 */
public data class V2modelsSlotTypeExternalSourceSettingGrammarSlotTypeSettingSource(
    public val kmsKeyArn: String,
    public val s3BucketName: String,
    public val s3ObjectKey: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsSlotTypeExternalSourceSettingGrammarSlotTypeSettingSource): V2modelsSlotTypeExternalSourceSettingGrammarSlotTypeSettingSource =
            V2modelsSlotTypeExternalSourceSettingGrammarSlotTypeSettingSource(
                kmsKeyArn = javaType.kmsKeyArn(),
                s3BucketName = javaType.s3BucketName(),
                s3ObjectKey = javaType.s3ObjectKey(),
            )
    }
}
