@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property slotTypeValues List of SlotTypeValue objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot. See `slot_type_values` argument reference below.
 * @property synonyms Additional values related to the slot type entry. See `sample_value` argument reference below.
 */
public data class V2modelsSlotTypeSlotTypeValues(
    public val slotTypeValues: List<V2modelsSlotTypeSlotTypeValuesSlotTypeValue>,
    public val synonyms: List<V2modelsSlotTypeSlotTypeValuesSynonym>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsSlotTypeSlotTypeValues): V2modelsSlotTypeSlotTypeValues = V2modelsSlotTypeSlotTypeValues(
            slotTypeValues = javaType.slotTypeValues().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.V2modelsSlotTypeSlotTypeValuesSlotTypeValue.Companion.toKotlin(args0)
                })
            }),
            synonyms = javaType.synonyms().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.V2modelsSlotTypeSlotTypeValuesSynonym.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
