@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property advancedRecognitionSettings Provides settings that enable advanced recognition settings for slot values. You can use this to enable using slot values as a custom vocabulary for recognizing user utterances. See [`advanced_recognition_setting` argument reference] below.
 * @property regexFilters Used to validate the value of the slot. See [`regex_filter` argument reference] below.
 * @property resolutionStrategy Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be set to one of the following values: `ORIGINAL_VALUE` - Returns the value entered by the user, if the user value is similar to the slot value. `TOP_RESOLUTION` If there is a resolution list for the slot, return the first value in the resolution list as the slot type value. If there is no resolution list, null is returned. If you don't specify the valueSelectionStrategy , the default is `ORIGINAL_VALUE`. Valid values are `OriginalValue`, `TopResolution`, and `Concatenation`.
 */
public data class V2modelsSlotTypeValueSelectionSetting(
    public val advancedRecognitionSettings: List<V2modelsSlotTypeValueSelectionSettingAdvancedRecognitionSetting>? = null,
    public val regexFilters: List<V2modelsSlotTypeValueSelectionSettingRegexFilter>? = null,
    public val resolutionStrategy: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsSlotTypeValueSelectionSetting): V2modelsSlotTypeValueSelectionSetting = V2modelsSlotTypeValueSelectionSetting(
            advancedRecognitionSettings = javaType.advancedRecognitionSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.V2modelsSlotTypeValueSelectionSettingAdvancedRecognitionSetting.Companion.toKotlin(args0)
                })
            }),
            regexFilters = javaType.regexFilters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.V2modelsSlotTypeValueSelectionSettingRegexFilter.Companion.toKotlin(args0)
                })
            }),
            resolutionStrategy = javaType.resolutionStrategy(),
        )
    }
}
