@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property pattern Used to validate the value of a slot. Use a standard regular expression. Amazon Lex supports the following characters in the regular expression: A-Z, a-z, 0-9, Unicode characters ("\⁠u").
 * Represent Unicode characters with four digits, for example "\⁠u0041" or "\⁠u005A". The following regular expression operators are not supported: Infinite repeaters: *, +, or {x,} with no upper bound, wild card (.)
 */
public data class V2modelsSlotTypeValueSelectionSettingRegexFilter(
    public val pattern: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsSlotTypeValueSelectionSettingRegexFilter): V2modelsSlotTypeValueSelectionSettingRegexFilter =
            V2modelsSlotTypeValueSelectionSettingRegexFilter(
                pattern = javaType.pattern(),
            )
    }
}
