@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.licensemanager.kotlin

import com.pulumi.aws.licensemanager.LicenseGrantArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a License Manager grant. This allows for sharing licenses with other AWS accounts.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   test:
 *     type: aws:licensemanager:LicenseGrant
 *     properties:
 *       name: share-license-with-account
 *       allowedOperations:
 *         - ListPurchasedLicenses
 *         - CheckoutLicense
 *         - CheckInLicense
 *         - ExtendConsumptionLicense
 *         - CreateToken
 *       licenseArn: arn:aws:license-manager::111111111111:license:l-exampleARN
 *       principal: arn:aws:iam::111111111112:root
 *       homeRegion: us-east-1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_licensemanager_grant` using the grant arn. For example:
 * ```sh
 * $ pulumi import aws:licensemanager/licenseGrant:LicenseGrant test arn:aws:license-manager::123456789011:grant:g-01d313393d9e443d8664cc054db1e089
 * ```
 * @property allowedOperations A list of the allowed operations for the grant. This is a subset of the allowed operations on the license.
 * @property licenseArn The ARN of the license to grant.
 * @property name The Name of the grant.
 * @property principal The target account for the grant in the form of the ARN for an account principal of the root user.
 */
public data class LicenseGrantArgs(
    public val allowedOperations: Output<List<String>>? = null,
    public val licenseArn: Output<String>? = null,
    public val name: Output<String>? = null,
    public val principal: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.licensemanager.LicenseGrantArgs> {
    override fun toJava(): com.pulumi.aws.licensemanager.LicenseGrantArgs =
        com.pulumi.aws.licensemanager.LicenseGrantArgs.builder()
            .allowedOperations(allowedOperations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .licenseArn(licenseArn?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .principal(principal?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LicenseGrantArgs].
 */
@PulumiTagMarker
public class LicenseGrantArgsBuilder internal constructor() {
    private var allowedOperations: Output<List<String>>? = null

    private var licenseArn: Output<String>? = null

    private var name: Output<String>? = null

    private var principal: Output<String>? = null

    /**
     * @param value A list of the allowed operations for the grant. This is a subset of the allowed operations on the license.
     */
    @JvmName("sufibcjxwtfrmfdu")
    public suspend fun allowedOperations(`value`: Output<List<String>>) {
        this.allowedOperations = value
    }

    @JvmName("xbcbgehamggmjdon")
    public suspend fun allowedOperations(vararg values: Output<String>) {
        this.allowedOperations = Output.all(values.asList())
    }

    /**
     * @param values A list of the allowed operations for the grant. This is a subset of the allowed operations on the license.
     */
    @JvmName("vfgnprggdtaqvbhp")
    public suspend fun allowedOperations(values: List<Output<String>>) {
        this.allowedOperations = Output.all(values)
    }

    /**
     * @param value The ARN of the license to grant.
     */
    @JvmName("mirbqiahbbryuqdd")
    public suspend fun licenseArn(`value`: Output<String>) {
        this.licenseArn = value
    }

    /**
     * @param value The Name of the grant.
     */
    @JvmName("ngeilwqaevxjjche")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The target account for the grant in the form of the ARN for an account principal of the root user.
     */
    @JvmName("lgfklclrlronwauq")
    public suspend fun principal(`value`: Output<String>) {
        this.principal = value
    }

    /**
     * @param value A list of the allowed operations for the grant. This is a subset of the allowed operations on the license.
     */
    @JvmName("rqhwxfdilfpjyjvr")
    public suspend fun allowedOperations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedOperations = mapped
    }

    /**
     * @param values A list of the allowed operations for the grant. This is a subset of the allowed operations on the license.
     */
    @JvmName("lwrixqvyynkkcgsd")
    public suspend fun allowedOperations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedOperations = mapped
    }

    /**
     * @param value The ARN of the license to grant.
     */
    @JvmName("juulapaxgsyrqhkf")
    public suspend fun licenseArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseArn = mapped
    }

    /**
     * @param value The Name of the grant.
     */
    @JvmName("jyltljdsefldfevc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The target account for the grant in the form of the ARN for an account principal of the root user.
     */
    @JvmName("dmkdnxxsufelgxlv")
    public suspend fun principal(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principal = mapped
    }

    internal fun build(): LicenseGrantArgs = LicenseGrantArgs(
        allowedOperations = allowedOperations,
        licenseArn = licenseArn,
        name = name,
        principal = principal,
    )
}
