@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.licensemanager.kotlin

import com.pulumi.aws.licensemanager.LicensemanagerFunctions.getLicenseGrantsPlain
import com.pulumi.aws.licensemanager.LicensemanagerFunctions.getReceivedLicensePlain
import com.pulumi.aws.licensemanager.LicensemanagerFunctions.getReceivedLicensesPlain
import com.pulumi.aws.licensemanager.kotlin.inputs.GetLicenseGrantsFilter
import com.pulumi.aws.licensemanager.kotlin.inputs.GetLicenseGrantsPlainArgs
import com.pulumi.aws.licensemanager.kotlin.inputs.GetLicenseGrantsPlainArgsBuilder
import com.pulumi.aws.licensemanager.kotlin.inputs.GetReceivedLicensePlainArgs
import com.pulumi.aws.licensemanager.kotlin.inputs.GetReceivedLicensePlainArgsBuilder
import com.pulumi.aws.licensemanager.kotlin.inputs.GetReceivedLicensesFilter
import com.pulumi.aws.licensemanager.kotlin.inputs.GetReceivedLicensesPlainArgs
import com.pulumi.aws.licensemanager.kotlin.inputs.GetReceivedLicensesPlainArgsBuilder
import com.pulumi.aws.licensemanager.kotlin.outputs.GetLicenseGrantsResult
import com.pulumi.aws.licensemanager.kotlin.outputs.GetReceivedLicenseResult
import com.pulumi.aws.licensemanager.kotlin.outputs.GetReceivedLicensesResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.licensemanager.kotlin.outputs.GetLicenseGrantsResult.Companion.toKotlin as getLicenseGrantsResultToKotlin
import com.pulumi.aws.licensemanager.kotlin.outputs.GetReceivedLicenseResult.Companion.toKotlin as getReceivedLicenseResultToKotlin
import com.pulumi.aws.licensemanager.kotlin.outputs.GetReceivedLicensesResult.Companion.toKotlin as getReceivedLicensesResultToKotlin

public object LicensemanagerFunctions {
    /**
     * This resource can be used to get a set of license grant ARNs matching a filter.
     * ## Example Usage
     * The following shows getting all license grant ARNs granted to your account.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const current = aws.getCallerIdentity({});
     * const test = current.then(current => aws.licensemanager.getLicenseGrants({
     *     filters: [{
     *         name: "GranteePrincipalARN",
     *         values: [`arn:aws:iam::${current&#46;accountId}:root`],
     *     }],
     * }));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * current = aws.get_caller_identity()
     * test = aws.licensemanager.get_license_grants(filters=[{
     *     "name": "GranteePrincipalARN",
     *     "values": [f"arn:aws:iam::{current&#46;account_id}:root"],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = Aws.GetCallerIdentity.Invoke();
     *     var test = Aws.LicenseManager.GetLicenseGrants.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.LicenseManager.Inputs.GetLicenseGrantsFilterInputArgs
     *             {
     *                 Name = "GranteePrincipalARN",
     *                 Values = new[]
     *                 {
     *                     $"arn:aws:iam::{current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId)}:root",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"fmt"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/licensemanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = licensemanager.GetLicenseGrants(ctx, &licensemanager.GetLicenseGrantsArgs{
     * 			Filters: []licensemanager.GetLicenseGrantsFilter{
     * 				{
     * 					Name: "GranteePrincipalARN",
     * 					Values: []string{
     * 						fmt.Sprintf("arn:aws:iam::%v:root", current.AccountId),
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
     * import com.pulumi.aws.licensemanager.LicensemanagerFunctions;
     * import com.pulumi.aws.licensemanager.inputs.GetLicenseGrantsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getCallerIdentity();
     *         final var test = LicensemanagerFunctions.getLicenseGrants(GetLicenseGrantsArgs.builder()
     *             .filters(GetLicenseGrantsFilterArgs.builder()
     *                 .name("GranteePrincipalARN")
     *                 .values(String.format("arn:aws:iam::%s:root", current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: aws:getCallerIdentity
     *       Arguments: {}
     *   test:
     *     fn::invoke:
     *       Function: aws:licensemanager:getLicenseGrants
     *       Arguments:
     *         filters:
     *           - name: GranteePrincipalARN
     *             values:
     *               - arn:aws:iam::${current.accountId}:root
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getLicenseGrants.
     * @return A collection of values returned by getLicenseGrants.
     */
    public suspend fun getLicenseGrants(argument: GetLicenseGrantsPlainArgs): GetLicenseGrantsResult =
        getLicenseGrantsResultToKotlin(getLicenseGrantsPlain(argument.toJava()).await())

    /**
     * @see [getLicenseGrants].
     * @param filters Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getLicenseGrants.
     */
    public suspend fun getLicenseGrants(filters: List<GetLicenseGrantsFilter>? = null): GetLicenseGrantsResult {
        val argument = GetLicenseGrantsPlainArgs(
            filters = filters,
        )
        return getLicenseGrantsResultToKotlin(getLicenseGrantsPlain(argument.toJava()).await())
    }

    /**
     * @see [getLicenseGrants].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;licensemanager&#46;kotlin&#46;inputs&#46;GetLicenseGrantsPlainArgs].
     * @return A collection of values returned by getLicenseGrants.
     */
    public suspend fun getLicenseGrants(argument: suspend GetLicenseGrantsPlainArgsBuilder.() -> Unit): GetLicenseGrantsResult {
        val builder = GetLicenseGrantsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLicenseGrantsResultToKotlin(getLicenseGrantsPlain(builtArgument.toJava()).await())
    }

    /**
     * This resource can be used to get data on a received license using an ARN. This can be helpful for pulling in data on a license from the AWS marketplace and sharing that license with another account.
     * ## Example Usage
     * The following shows getting the received license data using and ARN.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.licensemanager.getReceivedLicense({
     *     licenseArn: "arn:aws:license-manager::111111111111:license:l-ecbaa94eb71a4830b6d7e49268fecaa0",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.licensemanager.get_received_license(license_arn="arn:aws:license-manager::111111111111:license:l-ecbaa94eb71a4830b6d7e49268fecaa0")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.LicenseManager.GetReceivedLicense.Invoke(new()
     *     {
     *         LicenseArn = "arn:aws:license-manager::111111111111:license:l-ecbaa94eb71a4830b6d7e49268fecaa0",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/licensemanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := licensemanager.GetReceivedLicense(ctx, &licensemanager.GetReceivedLicenseArgs{
     * 			LicenseArn: "arn:aws:license-manager::111111111111:license:l-ecbaa94eb71a4830b6d7e49268fecaa0",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.licensemanager.LicensemanagerFunctions;
     * import com.pulumi.aws.licensemanager.inputs.GetReceivedLicenseArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = LicensemanagerFunctions.getReceivedLicense(GetReceivedLicenseArgs.builder()
     *             .licenseArn("arn:aws:license-manager::111111111111:license:l-ecbaa94eb71a4830b6d7e49268fecaa0")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:licensemanager:getReceivedLicense
     *       Arguments:
     *         licenseArn: arn:aws:license-manager::111111111111:license:l-ecbaa94eb71a4830b6d7e49268fecaa0
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getReceivedLicense.
     * @return A collection of values returned by getReceivedLicense.
     */
    public suspend fun getReceivedLicense(argument: GetReceivedLicensePlainArgs): GetReceivedLicenseResult =
        getReceivedLicenseResultToKotlin(getReceivedLicensePlain(argument.toJava()).await())

    /**
     * @see [getReceivedLicense].
     * @param licenseArn The ARN of the received license you want data for.
     * @return A collection of values returned by getReceivedLicense.
     */
    public suspend fun getReceivedLicense(licenseArn: String): GetReceivedLicenseResult {
        val argument = GetReceivedLicensePlainArgs(
            licenseArn = licenseArn,
        )
        return getReceivedLicenseResultToKotlin(getReceivedLicensePlain(argument.toJava()).await())
    }

    /**
     * @see [getReceivedLicense].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;licensemanager&#46;kotlin&#46;inputs&#46;GetReceivedLicensePlainArgs].
     * @return A collection of values returned by getReceivedLicense.
     */
    public suspend fun getReceivedLicense(argument: suspend GetReceivedLicensePlainArgsBuilder.() -> Unit): GetReceivedLicenseResult {
        val builder = GetReceivedLicensePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReceivedLicenseResultToKotlin(getReceivedLicensePlain(builtArgument.toJava()).await())
    }

    /**
     * This resource can be used to get a set of license ARNs matching a filter.
     * ## Example Usage
     * The following shows getting all license ARNs issued from the AWS marketplace. Providing no filter, would provide all license ARNs for the entire account.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.licensemanager.getReceivedLicenses({
     *     filters: [{
     *         name: "IssuerName",
     *         values: ["AWS/Marketplace"],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.licensemanager.get_received_licenses(filters=[{
     *     "name": "IssuerName",
     *     "values": ["AWS/Marketplace"],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.LicenseManager.GetReceivedLicenses.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.LicenseManager.Inputs.GetReceivedLicensesFilterInputArgs
     *             {
     *                 Name = "IssuerName",
     *                 Values = new[]
     *                 {
     *                     "AWS/Marketplace",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/licensemanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := licensemanager.GetReceivedLicenses(ctx, &licensemanager.GetReceivedLicensesArgs{
     * 			Filters: []licensemanager.GetReceivedLicensesFilter{
     * 				{
     * 					Name: "IssuerName",
     * 					Values: []string{
     * 						"AWS/Marketplace",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.licensemanager.LicensemanagerFunctions;
     * import com.pulumi.aws.licensemanager.inputs.GetReceivedLicensesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = LicensemanagerFunctions.getReceivedLicenses(GetReceivedLicensesArgs.builder()
     *             .filters(GetReceivedLicensesFilterArgs.builder()
     *                 .name("IssuerName")
     *                 .values("AWS/Marketplace")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:licensemanager:getReceivedLicenses
     *       Arguments:
     *         filters:
     *           - name: IssuerName
     *             values:
     *               - AWS/Marketplace
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getReceivedLicenses.
     * @return A collection of values returned by getReceivedLicenses.
     */
    public suspend fun getReceivedLicenses(argument: GetReceivedLicensesPlainArgs): GetReceivedLicensesResult =
        getReceivedLicensesResultToKotlin(getReceivedLicensesPlain(argument.toJava()).await())

    /**
     * @see [getReceivedLicenses].
     * @param filters Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getReceivedLicenses.
     */
    public suspend fun getReceivedLicenses(filters: List<GetReceivedLicensesFilter>? = null): GetReceivedLicensesResult {
        val argument = GetReceivedLicensesPlainArgs(
            filters = filters,
        )
        return getReceivedLicensesResultToKotlin(getReceivedLicensesPlain(argument.toJava()).await())
    }

    /**
     * @see [getReceivedLicenses].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;licensemanager&#46;kotlin&#46;inputs&#46;GetReceivedLicensesPlainArgs].
     * @return A collection of values returned by getReceivedLicenses.
     */
    public suspend fun getReceivedLicenses(argument: suspend GetReceivedLicensesPlainArgsBuilder.() -> Unit): GetReceivedLicensesResult {
        val builder = GetReceivedLicensesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReceivedLicensesResultToKotlin(getReceivedLicensesPlain(builtArgument.toJava()).await())
    }
}
