@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.licensemanager.kotlin.inputs

import com.pulumi.aws.licensemanager.inputs.GetReceivedLicensePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getReceivedLicense.
 * @property licenseArn The ARN of the received license you want data for.
 */
public data class GetReceivedLicensePlainArgs(
    public val licenseArn: String,
) : ConvertibleToJava<com.pulumi.aws.licensemanager.inputs.GetReceivedLicensePlainArgs> {
    override fun toJava(): com.pulumi.aws.licensemanager.inputs.GetReceivedLicensePlainArgs =
        com.pulumi.aws.licensemanager.inputs.GetReceivedLicensePlainArgs.builder()
            .licenseArn(licenseArn.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReceivedLicensePlainArgs].
 */
@PulumiTagMarker
public class GetReceivedLicensePlainArgsBuilder internal constructor() {
    private var licenseArn: String? = null

    /**
     * @param value The ARN of the received license you want data for.
     */
    @JvmName("ujhbcrsavpkssjxk")
    public suspend fun licenseArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.licenseArn = mapped
    }

    internal fun build(): GetReceivedLicensePlainArgs = GetReceivedLicensePlainArgs(
        licenseArn = licenseArn ?: throw PulumiNullFieldException("licenseArn"),
    )
}
