@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.licensemanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property borrowConfigurations Details about a borrow configuration. Detailed below
 * @property provisionalConfigurations Details about a provisional configuration. Detailed below
 * @property renewType
 */
public data class GetReceivedLicenseConsumptionConfiguration(
    public val borrowConfigurations: List<GetReceivedLicenseConsumptionConfigurationBorrowConfiguration>,
    public val provisionalConfigurations: List<GetReceivedLicenseConsumptionConfigurationProvisionalConfiguration>,
    public val renewType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.licensemanager.outputs.GetReceivedLicenseConsumptionConfiguration): GetReceivedLicenseConsumptionConfiguration = GetReceivedLicenseConsumptionConfiguration(
            borrowConfigurations = javaType.borrowConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.licensemanager.kotlin.outputs.GetReceivedLicenseConsumptionConfigurationBorrowConfiguration.Companion.toKotlin(args0)
                })
            }),
            provisionalConfigurations = javaType.provisionalConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.licensemanager.kotlin.outputs.GetReceivedLicenseConsumptionConfigurationProvisionalConfiguration.Companion.toKotlin(args0)
                })
            }),
            renewType = javaType.renewType(),
        )
    }
}
