@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.licensemanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allowedOperations A list of allowed operations.
 * @property receivedStatus Received status.
 * @property receivedStatusReason Received status reason.
 */
public data class GetReceivedLicenseReceivedMetadata(
    public val allowedOperations: List<String>,
    public val receivedStatus: String,
    public val receivedStatusReason: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.licensemanager.outputs.GetReceivedLicenseReceivedMetadata): GetReceivedLicenseReceivedMetadata = GetReceivedLicenseReceivedMetadata(
            allowedOperations = javaType.allowedOperations().map({ args0 -> args0 }),
            receivedStatus = javaType.receivedStatus(),
            receivedStatusReason = javaType.receivedStatusReason(),
        )
    }
}
