@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.licensemanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getReceivedLicense.
 * @property beneficiary Granted license beneficiary. This is in the form of the ARN of the root user of the account.
 * @property consumptionConfigurations Configuration for consumption of the license. Detailed below
 * @property createTime Creation time of the granted license in RFC 3339 format.
 * @property entitlements License entitlements. Detailed below
 * @property homeRegion Home Region of the granted license.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property issuers Granted license issuer. Detailed below
 * @property licenseArn Amazon Resource Name (ARN) of the license.
 * @property licenseMetadatas Granted license metadata. This is in the form of a set of all meta data. Detailed below
 * @property licenseName License name.
 * @property productName Product name.
 * * `product_sku ` - Product SKU.
 * @property productSku
 * @property receivedMetadatas Granted license received metadata. Detailed below
 * @property status Granted license status.
 * @property validities Date and time range during which the granted license is valid, in ISO8601-UTC format. Detailed below
 * @property version Version of the granted license.
 */
public data class GetReceivedLicenseResult(
    public val beneficiary: String,
    public val consumptionConfigurations: List<GetReceivedLicenseConsumptionConfiguration>,
    public val createTime: String,
    public val entitlements: List<GetReceivedLicenseEntitlement>,
    public val homeRegion: String,
    public val id: String,
    public val issuers: List<GetReceivedLicenseIssuer>,
    public val licenseArn: String,
    public val licenseMetadatas: List<GetReceivedLicenseLicenseMetadata>,
    public val licenseName: String,
    public val productName: String,
    public val productSku: String,
    public val receivedMetadatas: List<GetReceivedLicenseReceivedMetadata>,
    public val status: String,
    public val validities: List<GetReceivedLicenseValidity>,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.licensemanager.outputs.GetReceivedLicenseResult): GetReceivedLicenseResult = GetReceivedLicenseResult(
            beneficiary = javaType.beneficiary(),
            consumptionConfigurations = javaType.consumptionConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.licensemanager.kotlin.outputs.GetReceivedLicenseConsumptionConfiguration.Companion.toKotlin(args0)
                })
            }),
            createTime = javaType.createTime(),
            entitlements = javaType.entitlements().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.licensemanager.kotlin.outputs.GetReceivedLicenseEntitlement.Companion.toKotlin(args0)
                })
            }),
            homeRegion = javaType.homeRegion(),
            id = javaType.id(),
            issuers = javaType.issuers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.licensemanager.kotlin.outputs.GetReceivedLicenseIssuer.Companion.toKotlin(args0)
                })
            }),
            licenseArn = javaType.licenseArn(),
            licenseMetadatas = javaType.licenseMetadatas().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.licensemanager.kotlin.outputs.GetReceivedLicenseLicenseMetadata.Companion.toKotlin(args0)
                })
            }),
            licenseName = javaType.licenseName(),
            productName = javaType.productName(),
            productSku = javaType.productSku(),
            receivedMetadatas = javaType.receivedMetadatas().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.licensemanager.kotlin.outputs.GetReceivedLicenseReceivedMetadata.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
            validities = javaType.validities().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.licensemanager.kotlin.outputs.GetReceivedLicenseValidity.Companion.toKotlin(args0)
                })
            }),
            version = javaType.version(),
        )
    }
}
