@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BucketAccessKey].
 */
@PulumiTagMarker
public class BucketAccessKeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketAccessKeyArgs = BucketAccessKeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketAccessKeyArgsBuilder.() -> Unit) {
        val builder = BucketAccessKeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BucketAccessKey {
        val builtJavaResource = com.pulumi.aws.lightsail.BucketAccessKey(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BucketAccessKey(builtJavaResource)
    }
}

/**
 * Provides a lightsail bucket access key. This is a set of credentials that allow API requests to be made to the lightsail bucket.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.lightsail.Bucket("test", {
 *     name: "mytestbucket",
 *     bundleId: "small_1_0",
 * });
 * const testLightsailBucketAccessKeyAccessKey = new aws.index.LightsailBucketAccessKeyAccessKey("test", {bucketName: testAwsLightsailBucketAccessKey.id});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.lightsail.Bucket("test",
 *     name="mytestbucket",
 *     bundle_id="small_1_0")
 * test_lightsail_bucket_access_key_access_key = aws.index.LightsailBucketAccessKeyAccessKey("test", bucket_name=test_aws_lightsail_bucket_access_key.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.LightSail.Bucket("test", new()
 *     {
 *         Name = "mytestbucket",
 *         BundleId = "small_1_0",
 *     });
 *     var testLightsailBucketAccessKeyAccessKey = new Aws.Index.LightsailBucketAccessKeyAccessKey("test", new()
 *     {
 *         BucketName = testAwsLightsailBucketAccessKey.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lightsail.NewBucket(ctx, "test", &lightsail.BucketArgs{
 * 			Name:     pulumi.String("mytestbucket"),
 * 			BundleId: pulumi.String("small_1_0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = aws.NewLightsailBucketAccessKeyAccessKey(ctx, "test", &aws.LightsailBucketAccessKeyAccessKeyArgs{
 * 			BucketName: testAwsLightsailBucketAccessKey.Id,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Bucket;
 * import com.pulumi.aws.lightsail.BucketArgs;
 * import com.pulumi.aws.lightsailBucketAccessKeyAccessKey;
 * import com.pulumi.aws.LightsailBucketAccessKeyAccessKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Bucket("test", BucketArgs.builder()
 *             .name("mytestbucket")
 *             .bundleId("small_1_0")
 *             .build());
 *         var testLightsailBucketAccessKeyAccessKey = new LightsailBucketAccessKeyAccessKey("testLightsailBucketAccessKeyAccessKey", LightsailBucketAccessKeyAccessKeyArgs.builder()
 *             .bucketName(testAwsLightsailBucketAccessKey.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:lightsail:Bucket
 *     properties:
 *       name: mytestbucket
 *       bundleId: small_1_0
 *   testLightsailBucketAccessKeyAccessKey:
 *     type: aws:lightsailBucketAccessKeyAccessKey
 *     name: test
 *     properties:
 *       bucketName: ${testAwsLightsailBucketAccessKey.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_bucket_access_key` using the `id` attribute. For example:
 * ```sh
 * $ pulumi import aws:lightsail/bucketAccessKey:BucketAccessKey test example-bucket,AKIAIOSFODNN7EXAMPLE
 * ```
 */
public class BucketAccessKey internal constructor(
    override val javaResource: com.pulumi.aws.lightsail.BucketAccessKey,
) : KotlinCustomResource(javaResource, BucketAccessKeyMapper) {
    /**
     * The ID of the access key.
     */
    public val accessKeyId: Output<String>
        get() = javaResource.accessKeyId().applyValue({ args0 -> args0 })

    /**
     * The name of the bucket that the new access key will belong to, and grant access to.
     */
    public val bucketName: Output<String>
        get() = javaResource.bucketName().applyValue({ args0 -> args0 })

    /**
     * The timestamp when the access key was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * The secret access key used to sign requests. This attribute is not available for imported resources. Note that this will be written to the state file.
     */
    public val secretAccessKey: Output<String>
        get() = javaResource.secretAccessKey().applyValue({ args0 -> args0 })

    /**
     * The status of the access key.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object BucketAccessKeyMapper : ResourceMapper<BucketAccessKey> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lightsail.BucketAccessKey::class == javaResource::class

    override fun map(javaResource: Resource): BucketAccessKey = BucketAccessKey(
        javaResource as
            com.pulumi.aws.lightsail.BucketAccessKey,
    )
}

/**
 * @see [BucketAccessKey].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketAccessKey].
 */
public suspend fun bucketAccessKey(
    name: String,
    block: suspend BucketAccessKeyResourceBuilder.() -> Unit,
): BucketAccessKey {
    val builder = BucketAccessKeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketAccessKey].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketAccessKey(name: String): BucketAccessKey {
    val builder = BucketAccessKeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
