@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.BucketAccessKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a lightsail bucket access key. This is a set of credentials that allow API requests to be made to the lightsail bucket.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.lightsail.Bucket("test", {
 *     name: "mytestbucket",
 *     bundleId: "small_1_0",
 * });
 * const testLightsailBucketAccessKeyAccessKey = new aws.index.LightsailBucketAccessKeyAccessKey("test", {bucketName: testAwsLightsailBucketAccessKey.id});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.lightsail.Bucket("test",
 *     name="mytestbucket",
 *     bundle_id="small_1_0")
 * test_lightsail_bucket_access_key_access_key = aws.index.LightsailBucketAccessKeyAccessKey("test", bucket_name=test_aws_lightsail_bucket_access_key.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.LightSail.Bucket("test", new()
 *     {
 *         Name = "mytestbucket",
 *         BundleId = "small_1_0",
 *     });
 *     var testLightsailBucketAccessKeyAccessKey = new Aws.Index.LightsailBucketAccessKeyAccessKey("test", new()
 *     {
 *         BucketName = testAwsLightsailBucketAccessKey.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lightsail.NewBucket(ctx, "test", &lightsail.BucketArgs{
 * 			Name:     pulumi.String("mytestbucket"),
 * 			BundleId: pulumi.String("small_1_0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = aws.NewLightsailBucketAccessKeyAccessKey(ctx, "test", &aws.LightsailBucketAccessKeyAccessKeyArgs{
 * 			BucketName: testAwsLightsailBucketAccessKey.Id,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Bucket;
 * import com.pulumi.aws.lightsail.BucketArgs;
 * import com.pulumi.aws.lightsailBucketAccessKeyAccessKey;
 * import com.pulumi.aws.LightsailBucketAccessKeyAccessKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Bucket("test", BucketArgs.builder()
 *             .name("mytestbucket")
 *             .bundleId("small_1_0")
 *             .build());
 *         var testLightsailBucketAccessKeyAccessKey = new LightsailBucketAccessKeyAccessKey("testLightsailBucketAccessKeyAccessKey", LightsailBucketAccessKeyAccessKeyArgs.builder()
 *             .bucketName(testAwsLightsailBucketAccessKey.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:lightsail:Bucket
 *     properties:
 *       name: mytestbucket
 *       bundleId: small_1_0
 *   testLightsailBucketAccessKeyAccessKey:
 *     type: aws:lightsailBucketAccessKeyAccessKey
 *     name: test
 *     properties:
 *       bucketName: ${testAwsLightsailBucketAccessKey.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_bucket_access_key` using the `id` attribute. For example:
 * ```sh
 * $ pulumi import aws:lightsail/bucketAccessKey:BucketAccessKey test example-bucket,AKIAIOSFODNN7EXAMPLE
 * ```
 * @property bucketName The name of the bucket that the new access key will belong to, and grant access to.
 */
public data class BucketAccessKeyArgs(
    public val bucketName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.BucketAccessKeyArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.BucketAccessKeyArgs =
        com.pulumi.aws.lightsail.BucketAccessKeyArgs.builder()
            .bucketName(bucketName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketAccessKeyArgs].
 */
@PulumiTagMarker
public class BucketAccessKeyArgsBuilder internal constructor() {
    private var bucketName: Output<String>? = null

    /**
     * @param value The name of the bucket that the new access key will belong to, and grant access to.
     */
    @JvmName("hmypmmvkunhyiaqs")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value The name of the bucket that the new access key will belong to, and grant access to.
     */
    @JvmName("ghrqnkxsvmvsgeqg")
    public suspend fun bucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    internal fun build(): BucketAccessKeyArgs = BucketAccessKeyArgs(
        bucketName = bucketName,
    )
}
