@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.ContainerServiceArgs.builder
import com.pulumi.aws.lightsail.kotlin.inputs.ContainerServicePrivateRegistryAccessArgs
import com.pulumi.aws.lightsail.kotlin.inputs.ContainerServicePrivateRegistryAccessArgsBuilder
import com.pulumi.aws.lightsail.kotlin.inputs.ContainerServicePublicDomainNamesArgs
import com.pulumi.aws.lightsail.kotlin.inputs.ContainerServicePublicDomainNamesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Amazon Lightsail container service is a highly scalable compute and networking resource on which you can deploy, run,
 * and manage containers. For more information, see
 * [Container services in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-container-services).
 * > **Note:** For more information about the AWS Regions in which you can create Amazon Lightsail container services,
 * see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail).
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const myContainerService = new aws.lightsail.ContainerService("my_container_service", {
 *     name: "container-service-1",
 *     power: "nano",
 *     scale: 1,
 *     isDisabled: false,
 *     tags: {
 *         foo1: "bar1",
 *         foo2: "",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * my_container_service = aws.lightsail.ContainerService("my_container_service",
 *     name="container-service-1",
 *     power="nano",
 *     scale=1,
 *     is_disabled=False,
 *     tags={
 *         "foo1": "bar1",
 *         "foo2": "",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var myContainerService = new Aws.LightSail.ContainerService("my_container_service", new()
 *     {
 *         Name = "container-service-1",
 *         Power = "nano",
 *         Scale = 1,
 *         IsDisabled = false,
 *         Tags =
 *         {
 *             { "foo1", "bar1" },
 *             { "foo2", "" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lightsail.NewContainerService(ctx, "my_container_service", &lightsail.ContainerServiceArgs{
 * 			Name:       pulumi.String("container-service-1"),
 * 			Power:      pulumi.String("nano"),
 * 			Scale:      pulumi.Int(1),
 * 			IsDisabled: pulumi.Bool(false),
 * 			Tags: pulumi.StringMap{
 * 				"foo1": pulumi.String("bar1"),
 * 				"foo2": pulumi.String(""),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.ContainerService;
 * import com.pulumi.aws.lightsail.ContainerServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myContainerService = new ContainerService("myContainerService", ContainerServiceArgs.builder()
 *             .name("container-service-1")
 *             .power("nano")
 *             .scale(1)
 *             .isDisabled(false)
 *             .tags(Map.ofEntries(
 *                 Map.entry("foo1", "bar1"),
 *                 Map.entry("foo2", "")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   myContainerService:
 *     type: aws:lightsail:ContainerService
 *     name: my_container_service
 *     properties:
 *       name: container-service-1
 *       power: nano
 *       scale: 1
 *       isDisabled: false
 *       tags:
 *         foo1: bar1
 *         foo2:
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Public Domain Names
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const myContainerService = new aws.lightsail.ContainerService("my_container_service", {publicDomainNames: {
 *     certificates: [{
 *         certificateName: "example-certificate",
 *         domainNames: ["www&#46;example&#46;com"],
 *     }],
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * my_container_service = aws.lightsail.ContainerService("my_container_service", public_domain_names={
 *     "certificates": [{
 *         "certificate_name": "example-certificate",
 *         "domain_names": ["www&#46;example&#46;com"],
 *     }],
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var myContainerService = new Aws.LightSail.ContainerService("my_container_service", new()
 *     {
 *         PublicDomainNames = new Aws.LightSail.Inputs.ContainerServicePublicDomainNamesArgs
 *         {
 *             Certificates = new[]
 *             {
 *                 new Aws.LightSail.Inputs.ContainerServicePublicDomainNamesCertificateArgs
 *                 {
 *                     CertificateName = "example-certificate",
 *                     DomainNames = new[]
 *                     {
 *                         "www.example.com",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lightsail.NewContainerService(ctx, "my_container_service", &lightsail.ContainerServiceArgs{
 * 			PublicDomainNames: &lightsail.ContainerServicePublicDomainNamesArgs{
 * 				Certificates: lightsail.ContainerServicePublicDomainNamesCertificateArray{
 * 					&lightsail.ContainerServicePublicDomainNamesCertificateArgs{
 * 						CertificateName: pulumi.String("example-certificate"),
 * 						DomainNames: pulumi.StringArray{
 * 							pulumi.String("www.example.com"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.ContainerService;
 * import com.pulumi.aws.lightsail.ContainerServiceArgs;
 * import com.pulumi.aws.lightsail.inputs.ContainerServicePublicDomainNamesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myContainerService = new ContainerService("myContainerService", ContainerServiceArgs.builder()
 *             .publicDomainNames(ContainerServicePublicDomainNamesArgs.builder()
 *                 .certificates(ContainerServicePublicDomainNamesCertificateArgs.builder()
 *                     .certificateName("example-certificate")
 *                     .domainNames("www.example.com")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   myContainerService:
 *     type: aws:lightsail:ContainerService
 *     name: my_container_service
 *     properties:
 *       publicDomainNames:
 *         certificates:
 *           - certificateName: example-certificate
 *             domainNames:
 *               - www.example.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Private Registry Access
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const defaultContainerService = new aws.lightsail.ContainerService("default", {privateRegistryAccess: {
 *     ecrImagePullerRole: {
 *         isActive: true,
 *     },
 * }});
 * const default = defaultContainerService.privateRegistryAccess.apply(privateRegistryAccess => aws.iam.getPolicyDocumentOutput({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "AWS",
 *             identifiers: [privateRegistryAccess&#46;ecrImagePullerRole?&#46;principalArn],
 *         }],
 *         actions: [
 *             "ecr:BatchGetImage",
 *             "ecr:GetDownloadUrlForLayer",
 *         ],
 *     }],
 * }));
 * const defaultRepositoryPolicy = new aws.ecr.RepositoryPolicy("default", {
 *     repository: defaultAwsEcrRepository.name,
 *     policy: _default.apply(_default => _default.json),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default_container_service = aws.lightsail.ContainerService("default", private_registry_access={
 *     "ecr_image_puller_role": {
 *         "is_active": True,
 *     },
 * })
 * default = default_container_service.private_registry_access.apply(lambda private_registry_access: aws.iam.get_policy_document_output(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "AWS",
 *         "identifiers": [private_registry_access&#46;ecr_image_puller_role&#46;principal_arn],
 *     }],
 *     "actions": [
 *         "ecr:BatchGetImage",
 *         "ecr:GetDownloadUrlForLayer",
 *     ],
 * }]))
 * default_repository_policy = aws.ecr.RepositoryPolicy("default",
 *     repository=default_aws_ecr_repository["name"],
 *     policy=default.json)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var defaultContainerService = new Aws.LightSail.ContainerService("default", new()
 *     {
 *         PrivateRegistryAccess = new Aws.LightSail.Inputs.ContainerServicePrivateRegistryAccessArgs
 *         {
 *             EcrImagePullerRole = new Aws.LightSail.Inputs.ContainerServicePrivateRegistryAccessEcrImagePullerRoleArgs
 *             {
 *                 IsActive = true,
 *             },
 *         },
 *     });
 *     var @default = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "AWS",
 *                         Identifiers = new[]
 *                         {
 *                             defaultContainerService.PrivateRegistryAccess.EcrImagePullerRole?.PrincipalArn,
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "ecr:BatchGetImage",
 *                     "ecr:GetDownloadUrlForLayer",
 *                 },
 *             },
 *         },
 *     });
 *     var defaultRepositoryPolicy = new Aws.Ecr.RepositoryPolicy("default", new()
 *     {
 *         Repository = defaultAwsEcrRepository.Name,
 *         Policy = @default.Apply(@default => @default.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json)),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecr"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * defaultContainerService, err := lightsail.NewContainerService(ctx, "default", &lightsail.ContainerServiceArgs{
 * PrivateRegistryAccess: &lightsail.ContainerServicePrivateRegistryAccessArgs{
 * EcrImagePullerRole: &lightsail.ContainerServicePrivateRegistryAccessEcrImagePullerRoleArgs{
 * IsActive: pulumi.Bool(true),
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * _default := defaultContainerService.PrivateRegistryAccess.ApplyT(func(privateRegistryAccess lightsail.ContainerServicePrivateRegistryAccess) (iam.GetPolicyDocumentResult, error) {
 * return iam.GetPolicyDocumentResult(interface{}(iam.GetPolicyDocumentOutput(ctx, iam.GetPolicyDocumentOutputArgs{
 * Statements: []iam.GetPolicyDocumentStatement{
 * {
 * Effect: "Allow",
 * Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * {
 * Type: "AWS",
 * Identifiers: interface{}{
 * privateRegistryAccess.EcrImagePullerRole.PrincipalArn,
 * },
 * },
 * },
 * Actions: []string{
 * "ecr:BatchGetImage",
 * "ecr:GetDownloadUrlForLayer",
 * },
 * },
 * },
 * }, nil))), nil
 * }).(iam.GetPolicyDocumentResultOutput)
 * _, err = ecr.NewRepositoryPolicy(ctx, "default", &ecr.RepositoryPolicyArgs{
 * Repository: pulumi.Any(defaultAwsEcrRepository.Name),
 * Policy: pulumi.String(_default.ApplyT(func(_default iam.GetPolicyDocumentResult) (*string, error) {
 * return &default.Json, nil
 * }).(pulumi.StringPtrOutput)),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.ContainerService;
 * import com.pulumi.aws.lightsail.ContainerServiceArgs;
 * import com.pulumi.aws.lightsail.inputs.ContainerServicePrivateRegistryAccessArgs;
 * import com.pulumi.aws.lightsail.inputs.ContainerServicePrivateRegistryAccessEcrImagePullerRoleArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.ecr.RepositoryPolicy;
 * import com.pulumi.aws.ecr.RepositoryPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultContainerService = new ContainerService("defaultContainerService", ContainerServiceArgs.builder()
 *             .privateRegistryAccess(ContainerServicePrivateRegistryAccessArgs.builder()
 *                 .ecrImagePullerRole(ContainerServicePrivateRegistryAccessEcrImagePullerRoleArgs.builder()
 *                     .isActive(true)
 *                     .build())
 *                 .build())
 *             .build());
 *         final var default = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers(defaultContainerService.privateRegistryAccess().applyValue(privateRegistryAccess -> privateRegistryAccess.ecrImagePullerRole().principalArn()))
 *                     .build())
 *                 .actions(
 *                     "ecr:BatchGetImage",
 *                     "ecr:GetDownloadUrlForLayer")
 *                 .build())
 *             .build());
 *         var defaultRepositoryPolicy = new RepositoryPolicy("defaultRepositoryPolicy", RepositoryPolicyArgs.builder()
 *             .repository(defaultAwsEcrRepository.name())
 *             .policy(default_.applyValue(default_ -> default_.json()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultContainerService:
 *     type: aws:lightsail:ContainerService
 *     name: default
 *     properties:
 *       privateRegistryAccess:
 *         ecrImagePullerRole:
 *           isActive: true
 *   defaultRepositoryPolicy:
 *     type: aws:ecr:RepositoryPolicy
 *     name: default
 *     properties:
 *       repository: ${defaultAwsEcrRepository.name}
 *       policy: ${default.json}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: AWS
 *                 identifiers:
 *                   - ${defaultContainerService.privateRegistryAccess.ecrImagePullerRole.principalArn}
 *             actions:
 *               - ecr:BatchGetImage
 *               - ecr:GetDownloadUrlForLayer
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Lightsail Container Service using the `name`. For example:
 * ```sh
 * $ pulumi import aws:lightsail/containerService:ContainerService my_container_service container-service-1
 * ```
 * @property isDisabled A Boolean value indicating whether the container service is disabled. Defaults to `false`.
 * @property name The name for the container service. Names must be of length 1 to 63, and be
 * unique within each AWS Region in your Lightsail account.
 * @property power The power specification for the container service. The power specifies the amount of memory,
 * the number of vCPUs, and the monthly price of each node of the container service.
 * Possible values: `nano`, `micro`, `small`, `medium`, `large`, `xlarge`.
 * @property privateRegistryAccess An object to describe the configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See Private Registry Access below for more details.
 * @property publicDomainNames The public domain names to use with the container service, such as example.com
 * and www.example.com. You can specify up to four public domain names for a container service. The domain names that you
 * specify are used when you create a deployment with a container configured as the public endpoint of your container
 * service. If you don't specify public domain names, then you can use the default domain of the container service.
 * Defined below.
 * @property scale The scale specification for the container service. The scale specifies the allocated compute
 * nodes of the container service.
 * @property tags Map of container service tags. To create a key-only tag, use an empty string as the value. To tag at launch, specify the tags in the Launch Template. If
 * configured with a provider
 * `default_tags` configuration block
 * present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ContainerServiceArgs(
    public val isDisabled: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val power: Output<String>? = null,
    public val privateRegistryAccess: Output<ContainerServicePrivateRegistryAccessArgs>? = null,
    public val publicDomainNames: Output<ContainerServicePublicDomainNamesArgs>? = null,
    public val scale: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.ContainerServiceArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.ContainerServiceArgs =
        com.pulumi.aws.lightsail.ContainerServiceArgs.builder()
            .isDisabled(isDisabled?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .power(power?.applyValue({ args0 -> args0 }))
            .privateRegistryAccess(
                privateRegistryAccess?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .publicDomainNames(publicDomainNames?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scale(scale?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ContainerServiceArgs].
 */
@PulumiTagMarker
public class ContainerServiceArgsBuilder internal constructor() {
    private var isDisabled: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var power: Output<String>? = null

    private var privateRegistryAccess: Output<ContainerServicePrivateRegistryAccessArgs>? = null

    private var publicDomainNames: Output<ContainerServicePublicDomainNamesArgs>? = null

    private var scale: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A Boolean value indicating whether the container service is disabled. Defaults to `false`.
     */
    @JvmName("knqailwldrfupjkv")
    public suspend fun isDisabled(`value`: Output<Boolean>) {
        this.isDisabled = value
    }

    /**
     * @param value The name for the container service. Names must be of length 1 to 63, and be
     * unique within each AWS Region in your Lightsail account.
     */
    @JvmName("twexsunxwjstxutw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The power specification for the container service. The power specifies the amount of memory,
     * the number of vCPUs, and the monthly price of each node of the container service.
     * Possible values: `nano`, `micro`, `small`, `medium`, `large`, `xlarge`.
     */
    @JvmName("cmqfrqcrvojldbqc")
    public suspend fun power(`value`: Output<String>) {
        this.power = value
    }

    /**
     * @param value An object to describe the configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See Private Registry Access below for more details.
     */
    @JvmName("wvfoqkhplhlulood")
    public suspend fun privateRegistryAccess(`value`: Output<ContainerServicePrivateRegistryAccessArgs>) {
        this.privateRegistryAccess = value
    }

    /**
     * @param value The public domain names to use with the container service, such as example.com
     * and www.example.com. You can specify up to four public domain names for a container service. The domain names that you
     * specify are used when you create a deployment with a container configured as the public endpoint of your container
     * service. If you don't specify public domain names, then you can use the default domain of the container service.
     * Defined below.
     */
    @JvmName("sqkmknexwcfvhcfd")
    public suspend fun publicDomainNames(`value`: Output<ContainerServicePublicDomainNamesArgs>) {
        this.publicDomainNames = value
    }

    /**
     * @param value The scale specification for the container service. The scale specifies the allocated compute
     * nodes of the container service.
     */
    @JvmName("ailsrapdfyxycohg")
    public suspend fun scale(`value`: Output<Int>) {
        this.scale = value
    }

    /**
     * @param value Map of container service tags. To create a key-only tag, use an empty string as the value. To tag at launch, specify the tags in the Launch Template. If
     * configured with a provider
     * `default_tags` configuration block
     * present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vmmnmtouvmhivmau")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A Boolean value indicating whether the container service is disabled. Defaults to `false`.
     */
    @JvmName("wjcigtfrpjnslctj")
    public suspend fun isDisabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDisabled = mapped
    }

    /**
     * @param value The name for the container service. Names must be of length 1 to 63, and be
     * unique within each AWS Region in your Lightsail account.
     */
    @JvmName("nxpiivdvgrkxgdjk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The power specification for the container service. The power specifies the amount of memory,
     * the number of vCPUs, and the monthly price of each node of the container service.
     * Possible values: `nano`, `micro`, `small`, `medium`, `large`, `xlarge`.
     */
    @JvmName("fancbffobdpovhwl")
    public suspend fun power(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.power = mapped
    }

    /**
     * @param value An object to describe the configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See Private Registry Access below for more details.
     */
    @JvmName("paqepljdkwbkhpwo")
    public suspend fun privateRegistryAccess(`value`: ContainerServicePrivateRegistryAccessArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateRegistryAccess = mapped
    }

    /**
     * @param argument An object to describe the configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See Private Registry Access below for more details.
     */
    @JvmName("lqtmnyhhoycmhrqx")
    public suspend fun privateRegistryAccess(argument: suspend ContainerServicePrivateRegistryAccessArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerServicePrivateRegistryAccessArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateRegistryAccess = mapped
    }

    /**
     * @param value The public domain names to use with the container service, such as example.com
     * and www.example.com. You can specify up to four public domain names for a container service. The domain names that you
     * specify are used when you create a deployment with a container configured as the public endpoint of your container
     * service. If you don't specify public domain names, then you can use the default domain of the container service.
     * Defined below.
     */
    @JvmName("hndgfbydbrmryysd")
    public suspend fun publicDomainNames(`value`: ContainerServicePublicDomainNamesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicDomainNames = mapped
    }

    /**
     * @param argument The public domain names to use with the container service, such as example.com
     * and www.example.com. You can specify up to four public domain names for a container service. The domain names that you
     * specify are used when you create a deployment with a container configured as the public endpoint of your container
     * service. If you don't specify public domain names, then you can use the default domain of the container service.
     * Defined below.
     */
    @JvmName("wlgvtuwfaubabyip")
    public suspend fun publicDomainNames(argument: suspend ContainerServicePublicDomainNamesArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerServicePublicDomainNamesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.publicDomainNames = mapped
    }

    /**
     * @param value The scale specification for the container service. The scale specifies the allocated compute
     * nodes of the container service.
     */
    @JvmName("bbmnsyhpudcfmcdq")
    public suspend fun scale(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scale = mapped
    }

    /**
     * @param value Map of container service tags. To create a key-only tag, use an empty string as the value. To tag at launch, specify the tags in the Launch Template. If
     * configured with a provider
     * `default_tags` configuration block
     * present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wpyftgusgasjblaf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of container service tags. To create a key-only tag, use an empty string as the value. To tag at launch, specify the tags in the Launch Template. If
     * configured with a provider
     * `default_tags` configuration block
     * present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ypsowiqojpswulsg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ContainerServiceArgs = ContainerServiceArgs(
        isDisabled = isDisabled,
        name = name,
        power = power,
        privateRegistryAccess = privateRegistryAccess,
        publicDomainNames = publicDomainNames,
        scale = scale,
        tags = tags,
    )
}
