@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.ContainerServiceDeploymentVersionArgs.builder
import com.pulumi.aws.lightsail.kotlin.inputs.ContainerServiceDeploymentVersionContainerArgs
import com.pulumi.aws.lightsail.kotlin.inputs.ContainerServiceDeploymentVersionContainerArgsBuilder
import com.pulumi.aws.lightsail.kotlin.inputs.ContainerServiceDeploymentVersionPublicEndpointArgs
import com.pulumi.aws.lightsail.kotlin.inputs.ContainerServiceDeploymentVersionPublicEndpointArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage a deployment version for your Amazon Lightsail container service.
 * > **NOTE:** The Amazon Lightsail container service must be enabled to create a deployment.
 * > **NOTE:** This resource allows you to manage an Amazon Lightsail container service deployment version but the provider cannot destroy it. Removing this resource from your configuration will remove it from your statefile.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lightsail.ContainerServiceDeploymentVersion("example", {
 *     containers: [{
 *         containerName: "hello-world",
 *         image: "amazon/amazon-lightsail:hello-world",
 *         commands: [],
 *         environment: {
 *             MY_ENVIRONMENT_VARIABLE: "my_value",
 *         },
 *         ports: {
 *             "80": "HTTP",
 *         },
 *     }],
 *     publicEndpoint: {
 *         containerName: "hello-world",
 *         containerPort: 80,
 *         healthCheck: {
 *             healthyThreshold: 2,
 *             unhealthyThreshold: 2,
 *             timeoutSeconds: 2,
 *             intervalSeconds: 5,
 *             path: "/",
 *             successCodes: "200-499",
 *         },
 *     },
 *     serviceName: exampleAwsLightsailContainerService.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lightsail.ContainerServiceDeploymentVersion("example",
 *     containers=[{
 *         "container_name": "hello-world",
 *         "image": "amazon/amazon-lightsail:hello-world",
 *         "commands": [],
 *         "environment": {
 *             "m_y__environmen_t__variable": "my_value",
 *         },
 *         "ports": {
 *             "_80": "HTTP",
 *         },
 *     }],
 *     public_endpoint={
 *         "container_name": "hello-world",
 *         "container_port": 80,
 *         "health_check": {
 *             "healthy_threshold": 2,
 *             "unhealthy_threshold": 2,
 *             "timeout_seconds": 2,
 *             "interval_seconds": 5,
 *             "path": "/",
 *             "success_codes": "200-499",
 *         },
 *     },
 *     service_name=example_aws_lightsail_container_service["name"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.LightSail.ContainerServiceDeploymentVersion("example", new()
 *     {
 *         Containers = new[]
 *         {
 *             new Aws.LightSail.Inputs.ContainerServiceDeploymentVersionContainerArgs
 *             {
 *                 ContainerName = "hello-world",
 *                 Image = "amazon/amazon-lightsail:hello-world",
 *                 Commands = new() { },
 *                 Environment =
 *                 {
 *                     { "MY_ENVIRONMENT_VARIABLE", "my_value" },
 *                 },
 *                 Ports =
 *                 {
 *                     { "80", "HTTP" },
 *                 },
 *             },
 *         },
 *         PublicEndpoint = new Aws.LightSail.Inputs.ContainerServiceDeploymentVersionPublicEndpointArgs
 *         {
 *             ContainerName = "hello-world",
 *             ContainerPort = 80,
 *             HealthCheck = new Aws.LightSail.Inputs.ContainerServiceDeploymentVersionPublicEndpointHealthCheckArgs
 *             {
 *                 HealthyThreshold = 2,
 *                 UnhealthyThreshold = 2,
 *                 TimeoutSeconds = 2,
 *                 IntervalSeconds = 5,
 *                 Path = "/",
 *                 SuccessCodes = "200-499",
 *             },
 *         },
 *         ServiceName = exampleAwsLightsailContainerService.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lightsail.NewContainerServiceDeploymentVersion(ctx, "example", &lightsail.ContainerServiceDeploymentVersionArgs{
 * 			Containers: lightsail.ContainerServiceDeploymentVersionContainerArray{
 * 				&lightsail.ContainerServiceDeploymentVersionContainerArgs{
 * 					ContainerName: pulumi.String("hello-world"),
 * 					Image:         pulumi.String("amazon/amazon-lightsail:hello-world"),
 * 					Commands:      pulumi.StringArray{},
 * 					Environment: pulumi.StringMap{
 * 						"MY_ENVIRONMENT_VARIABLE": pulumi.String("my_value"),
 * 					},
 * 					Ports: pulumi.StringMap{
 * 						"80": pulumi.String("HTTP"),
 * 					},
 * 				},
 * 			},
 * 			PublicEndpoint: &lightsail.ContainerServiceDeploymentVersionPublicEndpointArgs{
 * 				ContainerName: pulumi.String("hello-world"),
 * 				ContainerPort: pulumi.Int(80),
 * 				HealthCheck: &lightsail.ContainerServiceDeploymentVersionPublicEndpointHealthCheckArgs{
 * 					HealthyThreshold:   pulumi.Int(2),
 * 					UnhealthyThreshold: pulumi.Int(2),
 * 					TimeoutSeconds:     pulumi.Int(2),
 * 					IntervalSeconds:    pulumi.Int(5),
 * 					Path:               pulumi.String("/"),
 * 					SuccessCodes:       pulumi.String("200-499"),
 * 				},
 * 			},
 * 			ServiceName: pulumi.Any(exampleAwsLightsailContainerService.Name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.ContainerServiceDeploymentVersion;
 * import com.pulumi.aws.lightsail.ContainerServiceDeploymentVersionArgs;
 * import com.pulumi.aws.lightsail.inputs.ContainerServiceDeploymentVersionContainerArgs;
 * import com.pulumi.aws.lightsail.inputs.ContainerServiceDeploymentVersionPublicEndpointArgs;
 * import com.pulumi.aws.lightsail.inputs.ContainerServiceDeploymentVersionPublicEndpointHealthCheckArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ContainerServiceDeploymentVersion("example", ContainerServiceDeploymentVersionArgs.builder()
 *             .containers(ContainerServiceDeploymentVersionContainerArgs.builder()
 *                 .containerName("hello-world")
 *                 .image("amazon/amazon-lightsail:hello-world")
 *                 .commands()
 *                 .environment(Map.of("MY_ENVIRONMENT_VARIABLE", "my_value"))
 *                 .ports(Map.of("80", "HTTP"))
 *                 .build())
 *             .publicEndpoint(ContainerServiceDeploymentVersionPublicEndpointArgs.builder()
 *                 .containerName("hello-world")
 *                 .containerPort(80)
 *                 .healthCheck(ContainerServiceDeploymentVersionPublicEndpointHealthCheckArgs.builder()
 *                     .healthyThreshold(2)
 *                     .unhealthyThreshold(2)
 *                     .timeoutSeconds(2)
 *                     .intervalSeconds(5)
 *                     .path("/")
 *                     .successCodes("200-499")
 *                     .build())
 *                 .build())
 *             .serviceName(exampleAwsLightsailContainerService.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lightsail:ContainerServiceDeploymentVersion
 *     properties:
 *       containers:
 *         - containerName: hello-world
 *           image: amazon/amazon-lightsail:hello-world
 *           commands: []
 *           environment:
 *             MY_ENVIRONMENT_VARIABLE: my_value
 *           ports:
 *             '80': HTTP
 *       publicEndpoint:
 *         containerName: hello-world
 *         containerPort: 80
 *         healthCheck:
 *           healthyThreshold: 2
 *           unhealthyThreshold: 2
 *           timeoutSeconds: 2
 *           intervalSeconds: 5
 *           path: /
 *           successCodes: 200-499
 *       serviceName: ${exampleAwsLightsailContainerService.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Lightsail Container Service Deployment Version using the `service_name` and `version` separated by a slash (`/`). For example:
 * ```sh
 * $ pulumi import aws:lightsail/containerServiceDeploymentVersion:ContainerServiceDeploymentVersion example container-service-1/1
 * ```
 * @property containers A set of configuration blocks that describe the settings of the containers that will be launched on the container service. Maximum of 53. Detailed below.
 * @property publicEndpoint A configuration block that describes the settings of the public endpoint for the container service. Detailed below.
 * @property serviceName The name for the container service.
 */
public data class ContainerServiceDeploymentVersionArgs(
    public val containers: Output<List<ContainerServiceDeploymentVersionContainerArgs>>? = null,
    public val publicEndpoint: Output<ContainerServiceDeploymentVersionPublicEndpointArgs>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.ContainerServiceDeploymentVersionArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.ContainerServiceDeploymentVersionArgs =
        com.pulumi.aws.lightsail.ContainerServiceDeploymentVersionArgs.builder()
            .containers(
                containers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .publicEndpoint(publicEndpoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerServiceDeploymentVersionArgs].
 */
@PulumiTagMarker
public class ContainerServiceDeploymentVersionArgsBuilder internal constructor() {
    private var containers: Output<List<ContainerServiceDeploymentVersionContainerArgs>>? = null

    private var publicEndpoint: Output<ContainerServiceDeploymentVersionPublicEndpointArgs>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value A set of configuration blocks that describe the settings of the containers that will be launched on the container service. Maximum of 53. Detailed below.
     */
    @JvmName("hpuwhegjwgodrlxl")
    public suspend fun containers(`value`: Output<List<ContainerServiceDeploymentVersionContainerArgs>>) {
        this.containers = value
    }

    @JvmName("paopnportetptlyr")
    public suspend fun containers(vararg values: Output<ContainerServiceDeploymentVersionContainerArgs>) {
        this.containers = Output.all(values.asList())
    }

    /**
     * @param values A set of configuration blocks that describe the settings of the containers that will be launched on the container service. Maximum of 53. Detailed below.
     */
    @JvmName("dpjutmaihnvqyphf")
    public suspend fun containers(values: List<Output<ContainerServiceDeploymentVersionContainerArgs>>) {
        this.containers = Output.all(values)
    }

    /**
     * @param value A configuration block that describes the settings of the public endpoint for the container service. Detailed below.
     */
    @JvmName("nstvclxragcmyqnc")
    public suspend fun publicEndpoint(`value`: Output<ContainerServiceDeploymentVersionPublicEndpointArgs>) {
        this.publicEndpoint = value
    }

    /**
     * @param value The name for the container service.
     */
    @JvmName("dhjfwutuweogqvdv")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value A set of configuration blocks that describe the settings of the containers that will be launched on the container service. Maximum of 53. Detailed below.
     */
    @JvmName("mjvncjcsopcnbmeq")
    public suspend fun containers(`value`: List<ContainerServiceDeploymentVersionContainerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containers = mapped
    }

    /**
     * @param argument A set of configuration blocks that describe the settings of the containers that will be launched on the container service. Maximum of 53. Detailed below.
     */
    @JvmName("ieeyqxmvucbhejyx")
    public suspend fun containers(argument: List<suspend ContainerServiceDeploymentVersionContainerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerServiceDeploymentVersionContainerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param argument A set of configuration blocks that describe the settings of the containers that will be launched on the container service. Maximum of 53. Detailed below.
     */
    @JvmName("kdykctijufjihali")
    public suspend fun containers(vararg argument: suspend ContainerServiceDeploymentVersionContainerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerServiceDeploymentVersionContainerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param argument A set of configuration blocks that describe the settings of the containers that will be launched on the container service. Maximum of 53. Detailed below.
     */
    @JvmName("axsbdrxspjgamqou")
    public suspend fun containers(argument: suspend ContainerServiceDeploymentVersionContainerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerServiceDeploymentVersionContainerArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param values A set of configuration blocks that describe the settings of the containers that will be launched on the container service. Maximum of 53. Detailed below.
     */
    @JvmName("cgdrysudgfadfvoy")
    public suspend fun containers(vararg values: ContainerServiceDeploymentVersionContainerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containers = mapped
    }

    /**
     * @param value A configuration block that describes the settings of the public endpoint for the container service. Detailed below.
     */
    @JvmName("aquclcfnypedpadl")
    public suspend fun publicEndpoint(`value`: ContainerServiceDeploymentVersionPublicEndpointArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicEndpoint = mapped
    }

    /**
     * @param argument A configuration block that describes the settings of the public endpoint for the container service. Detailed below.
     */
    @JvmName("xxdortxsnabhixwn")
    public suspend fun publicEndpoint(argument: suspend ContainerServiceDeploymentVersionPublicEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerServiceDeploymentVersionPublicEndpointArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.publicEndpoint = mapped
    }

    /**
     * @param value The name for the container service.
     */
    @JvmName("dbecbqdftjojfiwl")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): ContainerServiceDeploymentVersionArgs =
        ContainerServiceDeploymentVersionArgs(
            containers = containers,
            publicEndpoint = publicEndpoint,
            serviceName = serviceName,
        )
}
