@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Disk].
 */
@PulumiTagMarker
public class DiskResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DiskArgs = DiskArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DiskArgsBuilder.() -> Unit) {
        val builder = DiskArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Disk {
        val builtJavaResource = com.pulumi.aws.lightsail.Disk(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Disk(builtJavaResource)
    }
}

/**
 * Provides a Lightsail Disk resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const available = aws.getAvailabilityZones({
 *     state: "available",
 *     filters: [{
 *         name: "opt-in-status",
 *         values: ["opt-in-not-required"],
 *     }],
 * });
 * const test = new aws.lightsail.Disk("test", {
 *     name: "test",
 *     sizeInGb: 8,
 *     availabilityZone: available.then(available => available.names?.[0]),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * available = aws.get_availability_zones(state="available",
 *     filters=[{
 *         "name": "opt-in-status",
 *         "values": ["opt-in-not-required"],
 *     }])
 * test = aws.lightsail.Disk("test",
 *     name="test",
 *     size_in_gb=8,
 *     availability_zone=available.names[0])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var available = Aws.GetAvailabilityZones.Invoke(new()
 *     {
 *         State = "available",
 *         Filters = new[]
 *         {
 *             new Aws.Inputs.GetAvailabilityZonesFilterInputArgs
 *             {
 *                 Name = "opt-in-status",
 *                 Values = new[]
 *                 {
 *                     "opt-in-not-required",
 *                 },
 *             },
 *         },
 *     });
 *     var test = new Aws.LightSail.Disk("test", new()
 *     {
 *         Name = "test",
 *         SizeInGb = 8,
 *         AvailabilityZone = available.Apply(getAvailabilityZonesResult => getAvailabilityZonesResult.Names[0]),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		available, err := aws.GetAvailabilityZones(ctx, &aws.GetAvailabilityZonesArgs{
 * 			State: pulumi.StringRef("available"),
 * 			Filters: []aws.GetAvailabilityZonesFilter{
 * 				{
 * 					Name: "opt-in-status",
 * 					Values: []string{
 * 						"opt-in-not-required",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lightsail.NewDisk(ctx, "test", &lightsail.DiskArgs{
 * 			Name:             pulumi.String("test"),
 * 			SizeInGb:         pulumi.Int(8),
 * 			AvailabilityZone: pulumi.String(available.Names[0]),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.lightsail.Disk;
 * import com.pulumi.aws.lightsail.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
 *             .state("available")
 *             .filters(GetAvailabilityZonesFilterArgs.builder()
 *                 .name("opt-in-status")
 *                 .values("opt-in-not-required")
 *                 .build())
 *             .build());
 *         var test = new Disk("test", DiskArgs.builder()
 *             .name("test")
 *             .sizeInGb(8)
 *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:lightsail:Disk
 *     properties:
 *       name: test
 *       sizeInGb: 8
 *       availabilityZone: ${available.names[0]}
 * variables:
 *   available:
 *     fn::invoke:
 *       Function: aws:getAvailabilityZones
 *       Arguments:
 *         state: available
 *         filters:
 *           - name: opt-in-status
 *             values:
 *               - opt-in-not-required
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_disk` using the name attribute. For example:
 * ```sh
 * $ pulumi import aws:lightsail/disk:Disk test test
 * ```
 */
public class Disk internal constructor(
    override val javaResource: com.pulumi.aws.lightsail.Disk,
) : KotlinCustomResource(javaResource, DiskMapper) {
    /**
     * The ARN of the Lightsail disk.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The Availability Zone in which to create your disk.
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * The timestamp when the disk was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * The name of the disk.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The size of the disk in GB.
     */
    public val sizeInGb: Output<Int>
        get() = javaResource.sizeInGb().applyValue({ args0 -> args0 })

    /**
     * The support code for the disk. Include this code in your email to support when you have questions about a disk in Lightsail. This code enables our support team to look up your Lightsail information more easily.
     */
    public val supportCode: Output<String>
        get() = javaResource.supportCode().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object DiskMapper : ResourceMapper<Disk> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lightsail.Disk::class == javaResource::class

    override fun map(javaResource: Resource): Disk = Disk(
        javaResource as
            com.pulumi.aws.lightsail.Disk,
    )
}

/**
 * @see [Disk].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Disk].
 */
public suspend fun disk(name: String, block: suspend DiskResourceBuilder.() -> Unit): Disk {
    val builder = DiskResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Disk].
 * @param name The _unique_ name of the resulting resource.
 */
public fun disk(name: String): Disk {
    val builder = DiskResourceBuilder()
    builder.name(name)
    return builder.build()
}
