@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Disk_attachment].
 */
@PulumiTagMarker
public class Disk_attachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: Disk_attachmentArgs = Disk_attachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend Disk_attachmentArgsBuilder.() -> Unit) {
        val builder = Disk_attachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Disk_attachment {
        val builtJavaResource = com.pulumi.aws.lightsail.Disk_attachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Disk_attachment(builtJavaResource)
    }
}

/**
 * Attaches a Lightsail disk to a Lightsail Instance
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const available = aws.getAvailabilityZones({
 *     state: "available",
 *     filters: [{
 *         name: "opt-in-status",
 *         values: ["opt-in-not-required"],
 *     }],
 * });
 * const test = new aws.lightsail.Disk("test", {
 *     name: "test-disk",
 *     sizeInGb: 8,
 *     availabilityZone: available.then(available => available.names?.[0]),
 * });
 * const testInstance = new aws.lightsail.Instance("test", {
 *     name: "test-instance",
 *     availabilityZone: available.then(available => available.names?.[0]),
 *     blueprintId: "amazon_linux_2",
 *     bundleId: "nano_3_0",
 * });
 * const testDisk_attachment = new aws.lightsail.Disk_attachment("test", {
 *     diskName: test.name,
 *     instanceName: testInstance.name,
 *     diskPath: "/dev/xvdf",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * available = aws.get_availability_zones(state="available",
 *     filters=[{
 *         "name": "opt-in-status",
 *         "values": ["opt-in-not-required"],
 *     }])
 * test = aws.lightsail.Disk("test",
 *     name="test-disk",
 *     size_in_gb=8,
 *     availability_zone=available.names[0])
 * test_instance = aws.lightsail.Instance("test",
 *     name="test-instance",
 *     availability_zone=available.names[0],
 *     blueprint_id="amazon_linux_2",
 *     bundle_id="nano_3_0")
 * test_disk_attachment = aws.lightsail.Disk_attachment("test",
 *     disk_name=test.name,
 *     instance_name=test_instance.name,
 *     disk_path="/dev/xvdf")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var available = Aws.GetAvailabilityZones.Invoke(new()
 *     {
 *         State = "available",
 *         Filters = new[]
 *         {
 *             new Aws.Inputs.GetAvailabilityZonesFilterInputArgs
 *             {
 *                 Name = "opt-in-status",
 *                 Values = new[]
 *                 {
 *                     "opt-in-not-required",
 *                 },
 *             },
 *         },
 *     });
 *     var test = new Aws.LightSail.Disk("test", new()
 *     {
 *         Name = "test-disk",
 *         SizeInGb = 8,
 *         AvailabilityZone = available.Apply(getAvailabilityZonesResult => getAvailabilityZonesResult.Names[0]),
 *     });
 *     var testInstance = new Aws.LightSail.Instance("test", new()
 *     {
 *         Name = "test-instance",
 *         AvailabilityZone = available.Apply(getAvailabilityZonesResult => getAvailabilityZonesResult.Names[0]),
 *         BlueprintId = "amazon_linux_2",
 *         BundleId = "nano_3_0",
 *     });
 *     var testDisk_attachment = new Aws.LightSail.Disk_attachment("test", new()
 *     {
 *         DiskName = test.Name,
 *         InstanceName = testInstance.Name,
 *         DiskPath = "/dev/xvdf",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		available, err := aws.GetAvailabilityZones(ctx, &aws.GetAvailabilityZonesArgs{
 * 			State: pulumi.StringRef("available"),
 * 			Filters: []aws.GetAvailabilityZonesFilter{
 * 				{
 * 					Name: "opt-in-status",
 * 					Values: []string{
 * 						"opt-in-not-required",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		test, err := lightsail.NewDisk(ctx, "test", &lightsail.DiskArgs{
 * 			Name:             pulumi.String("test-disk"),
 * 			SizeInGb:         pulumi.Int(8),
 * 			AvailabilityZone: pulumi.String(available.Names[0]),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testInstance, err := lightsail.NewInstance(ctx, "test", &lightsail.InstanceArgs{
 * 			Name:             pulumi.String("test-instance"),
 * 			AvailabilityZone: pulumi.String(available.Names[0]),
 * 			BlueprintId:      pulumi.String("amazon_linux_2"),
 * 			BundleId:         pulumi.String("nano_3_0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lightsail.NewDisk_attachment(ctx, "test", &lightsail.Disk_attachmentArgs{
 * 			DiskName:     test.Name,
 * 			InstanceName: testInstance.Name,
 * 			DiskPath:     pulumi.String("/dev/xvdf"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.lightsail.Disk;
 * import com.pulumi.aws.lightsail.DiskArgs;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import com.pulumi.aws.lightsail.Disk_attachment;
 * import com.pulumi.aws.lightsail.Disk_attachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
 *             .state("available")
 *             .filters(GetAvailabilityZonesFilterArgs.builder()
 *                 .name("opt-in-status")
 *                 .values("opt-in-not-required")
 *                 .build())
 *             .build());
 *         var test = new Disk("test", DiskArgs.builder()
 *             .name("test-disk")
 *             .sizeInGb(8)
 *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]))
 *             .build());
 *         var testInstance = new Instance("testInstance", InstanceArgs.builder()
 *             .name("test-instance")
 *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]))
 *             .blueprintId("amazon_linux_2")
 *             .bundleId("nano_3_0")
 *             .build());
 *         var testDisk_attachment = new Disk_attachment("testDisk_attachment", Disk_attachmentArgs.builder()
 *             .diskName(test.name())
 *             .instanceName(testInstance.name())
 *             .diskPath("/dev/xvdf")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:lightsail:Disk
 *     properties:
 *       name: test-disk
 *       sizeInGb: 8
 *       availabilityZone: ${available.names[0]}
 *   testInstance:
 *     type: aws:lightsail:Instance
 *     name: test
 *     properties:
 *       name: test-instance
 *       availabilityZone: ${available.names[0]}
 *       blueprintId: amazon_linux_2
 *       bundleId: nano_3_0
 *   testDisk_attachment:
 *     type: aws:lightsail:Disk_attachment
 *     name: test
 *     properties:
 *       diskName: ${test.name}
 *       instanceName: ${testInstance.name}
 *       diskPath: /dev/xvdf
 * variables:
 *   available:
 *     fn::invoke:
 *       Function: aws:getAvailabilityZones
 *       Arguments:
 *         state: available
 *         filters:
 *           - name: opt-in-status
 *             values:
 *               - opt-in-not-required
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_disk` using the id attribute. For example:
 * ```sh
 * $ pulumi import aws:lightsail/disk_attachment:Disk_attachment test test-disk,test-instance
 * ```
 */
public class Disk_attachment internal constructor(
    override val javaResource: com.pulumi.aws.lightsail.Disk_attachment,
) : KotlinCustomResource(javaResource, Disk_attachmentMapper) {
    /**
     * The name of the Lightsail Disk.
     */
    public val diskName: Output<String>
        get() = javaResource.diskName().applyValue({ args0 -> args0 })

    /**
     * The disk path to expose to the instance.
     */
    public val diskPath: Output<String>
        get() = javaResource.diskPath().applyValue({ args0 -> args0 })

    /**
     * The name of the Lightsail Instance to attach to.
     */
    public val instanceName: Output<String>
        get() = javaResource.instanceName().applyValue({ args0 -> args0 })
}

public object Disk_attachmentMapper : ResourceMapper<Disk_attachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lightsail.Disk_attachment::class == javaResource::class

    override fun map(javaResource: Resource): Disk_attachment = Disk_attachment(
        javaResource as
            com.pulumi.aws.lightsail.Disk_attachment,
    )
}

/**
 * @see [Disk_attachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Disk_attachment].
 */
public suspend fun disk_attachment(
    name: String,
    block: suspend Disk_attachmentResourceBuilder.() -> Unit,
): Disk_attachment {
    val builder = Disk_attachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Disk_attachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun disk_attachment(name: String): Disk_attachment {
    val builder = Disk_attachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
