@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.kotlin.outputs.DistributionCacheBehavior
import com.pulumi.aws.lightsail.kotlin.outputs.DistributionCacheBehaviorSettings
import com.pulumi.aws.lightsail.kotlin.outputs.DistributionDefaultCacheBehavior
import com.pulumi.aws.lightsail.kotlin.outputs.DistributionLocation
import com.pulumi.aws.lightsail.kotlin.outputs.DistributionOrigin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.lightsail.kotlin.outputs.DistributionCacheBehavior.Companion.toKotlin as distributionCacheBehaviorToKotlin
import com.pulumi.aws.lightsail.kotlin.outputs.DistributionCacheBehaviorSettings.Companion.toKotlin as distributionCacheBehaviorSettingsToKotlin
import com.pulumi.aws.lightsail.kotlin.outputs.DistributionDefaultCacheBehavior.Companion.toKotlin as distributionDefaultCacheBehaviorToKotlin
import com.pulumi.aws.lightsail.kotlin.outputs.DistributionLocation.Companion.toKotlin as distributionLocationToKotlin
import com.pulumi.aws.lightsail.kotlin.outputs.DistributionOrigin.Companion.toKotlin as distributionOriginToKotlin

/**
 * Builder for [Distribution].
 */
@PulumiTagMarker
public class DistributionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DistributionArgs = DistributionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DistributionArgsBuilder.() -> Unit) {
        val builder = DistributionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Distribution {
        val builtJavaResource = com.pulumi.aws.lightsail.Distribution(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Distribution(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Lightsail Distribution.
 * ## Example Usage
 * ### Basic Usage
 * Below is a basic example with a bucket as an origin.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.lightsail.Bucket("test", {
 *     name: "test-bucket",
 *     bundleId: "small_1_0",
 * });
 * const testDistribution = new aws.lightsail.Distribution("test", {
 *     name: "test-distribution",
 *     bundleId: "small_1_0",
 *     origin: {
 *         name: test.name,
 *         regionName: test.region,
 *     },
 *     defaultCacheBehavior: {
 *         behavior: "cache",
 *     },
 *     cacheBehaviorSettings: {
 *         allowedHttpMethods: "GET,HEAD,OPTIONS,PUT,PATCH,POST,DELETE",
 *         cachedHttpMethods: "GET,HEAD",
 *         defaultTtl: 86400,
 *         maximumTtl: 31536000,
 *         minimumTtl: 0,
 *         forwardedCookies: {
 *             option: "none",
 *         },
 *         forwardedHeaders: {
 *             option: "default",
 *         },
 *         forwardedQueryStrings: {
 *             option: false,
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.lightsail.Bucket("test",
 *     name="test-bucket",
 *     bundle_id="small_1_0")
 * test_distribution = aws.lightsail.Distribution("test",
 *     name="test-distribution",
 *     bundle_id="small_1_0",
 *     origin={
 *         "name": test.name,
 *         "region_name": test.region,
 *     },
 *     default_cache_behavior={
 *         "behavior": "cache",
 *     },
 *     cache_behavior_settings={
 *         "allowed_http_methods": "GET,HEAD,OPTIONS,PUT,PATCH,POST,DELETE",
 *         "cached_http_methods": "GET,HEAD",
 *         "default_ttl": 86400,
 *         "maximum_ttl": 31536000,
 *         "minimum_ttl": 0,
 *         "forwarded_cookies": {
 *             "option": "none",
 *         },
 *         "forwarded_headers": {
 *             "option": "default",
 *         },
 *         "forwarded_query_strings": {
 *             "option": False,
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.LightSail.Bucket("test", new()
 *     {
 *         Name = "test-bucket",
 *         BundleId = "small_1_0",
 *     });
 *     var testDistribution = new Aws.LightSail.Distribution("test", new()
 *     {
 *         Name = "test-distribution",
 *         BundleId = "small_1_0",
 *         Origin = new Aws.LightSail.Inputs.DistributionOriginArgs
 *         {
 *             Name = test.Name,
 *             RegionName = test.Region,
 *         },
 *         DefaultCacheBehavior = new Aws.LightSail.Inputs.DistributionDefaultCacheBehaviorArgs
 *         {
 *             Behavior = "cache",
 *         },
 *         CacheBehaviorSettings = new Aws.LightSail.Inputs.DistributionCacheBehaviorSettingsArgs
 *         {
 *             AllowedHttpMethods = "GET,HEAD,OPTIONS,PUT,PATCH,POST,DELETE",
 *             CachedHttpMethods = "GET,HEAD",
 *             DefaultTtl = 86400,
 *             MaximumTtl = 31536000,
 *             MinimumTtl = 0,
 *             ForwardedCookies = new Aws.LightSail.Inputs.DistributionCacheBehaviorSettingsForwardedCookiesArgs
 *             {
 *                 Option = "none",
 *             },
 *             ForwardedHeaders = new Aws.LightSail.Inputs.DistributionCacheBehaviorSettingsForwardedHeadersArgs
 *             {
 *                 Option = "default",
 *             },
 *             ForwardedQueryStrings = new Aws.LightSail.Inputs.DistributionCacheBehaviorSettingsForwardedQueryStringsArgs
 *             {
 *                 Option = false,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := lightsail.NewBucket(ctx, "test", &lightsail.BucketArgs{
 * 			Name:     pulumi.String("test-bucket"),
 * 			BundleId: pulumi.String("small_1_0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lightsail.NewDistribution(ctx, "test", &lightsail.DistributionArgs{
 * 			Name:     pulumi.String("test-distribution"),
 * 			BundleId: pulumi.String("small_1_0"),
 * 			Origin: &lightsail.DistributionOriginArgs{
 * 				Name:       test.Name,
 * 				RegionName: test.Region,
 * 			},
 * 			DefaultCacheBehavior: &lightsail.DistributionDefaultCacheBehaviorArgs{
 * 				Behavior: pulumi.String("cache"),
 * 			},
 * 			CacheBehaviorSettings: &lightsail.DistributionCacheBehaviorSettingsArgs{
 * 				AllowedHttpMethods: pulumi.String("GET,HEAD,OPTIONS,PUT,PATCH,POST,DELETE"),
 * 				CachedHttpMethods:  pulumi.String("GET,HEAD"),
 * 				DefaultTtl:         pulumi.Int(86400),
 * 				MaximumTtl:         pulumi.Int(31536000),
 * 				MinimumTtl:         pulumi.Int(0),
 * 				ForwardedCookies: &lightsail.DistributionCacheBehaviorSettingsForwardedCookiesArgs{
 * 					Option: pulumi.String("none"),
 * 				},
 * 				ForwardedHeaders: &lightsail.DistributionCacheBehaviorSettingsForwardedHeadersArgs{
 * 					Option: pulumi.String("default"),
 * 				},
 * 				ForwardedQueryStrings: &lightsail.DistributionCacheBehaviorSettingsForwardedQueryStringsArgs{
 * 					Option: pulumi.Bool(false),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Bucket;
 * import com.pulumi.aws.lightsail.BucketArgs;
 * import com.pulumi.aws.lightsail.Distribution;
 * import com.pulumi.aws.lightsail.DistributionArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionOriginArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionDefaultCacheBehaviorArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorSettingsArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorSettingsForwardedCookiesArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorSettingsForwardedHeadersArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionCacheBehaviorSettingsForwardedQueryStringsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Bucket("test", BucketArgs.builder()
 *             .name("test-bucket")
 *             .bundleId("small_1_0")
 *             .build());
 *         var testDistribution = new Distribution("testDistribution", DistributionArgs.builder()
 *             .name("test-distribution")
 *             .bundleId("small_1_0")
 *             .origin(DistributionOriginArgs.builder()
 *                 .name(test.name())
 *                 .regionName(test.region())
 *                 .build())
 *             .defaultCacheBehavior(DistributionDefaultCacheBehaviorArgs.builder()
 *                 .behavior("cache")
 *                 .build())
 *             .cacheBehaviorSettings(DistributionCacheBehaviorSettingsArgs.builder()
 *                 .allowedHttpMethods("GET,HEAD,OPTIONS,PUT,PATCH,POST,DELETE")
 *                 .cachedHttpMethods("GET,HEAD")
 *                 .defaultTtl(86400)
 *                 .maximumTtl(31536000)
 *                 .minimumTtl(0)
 *                 .forwardedCookies(DistributionCacheBehaviorSettingsForwardedCookiesArgs.builder()
 *                     .option("none")
 *                     .build())
 *                 .forwardedHeaders(DistributionCacheBehaviorSettingsForwardedHeadersArgs.builder()
 *                     .option("default")
 *                     .build())
 *                 .forwardedQueryStrings(DistributionCacheBehaviorSettingsForwardedQueryStringsArgs.builder()
 *                     .option(false)
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:lightsail:Bucket
 *     properties:
 *       name: test-bucket
 *       bundleId: small_1_0
 *   testDistribution:
 *     type: aws:lightsail:Distribution
 *     name: test
 *     properties:
 *       name: test-distribution
 *       bundleId: small_1_0
 *       origin:
 *         name: ${test.name}
 *         regionName: ${test.region}
 *       defaultCacheBehavior:
 *         behavior: cache
 *       cacheBehaviorSettings:
 *         allowedHttpMethods: GET,HEAD,OPTIONS,PUT,PATCH,POST,DELETE
 *         cachedHttpMethods: GET,HEAD
 *         defaultTtl: 86400
 *         maximumTtl: 3.1536e+07
 *         minimumTtl: 0
 *         forwardedCookies:
 *           option: none
 *         forwardedHeaders:
 *           option: default
 *         forwardedQueryStrings:
 *           option: false
 * ```
 * <!--End PulumiCodeChooser -->
 * ### instance origin example
 * Below is an example of an instance as the origin.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const available = aws.getAvailabilityZones({
 *     state: "available",
 *     filters: [{
 *         name: "opt-in-status",
 *         values: ["opt-in-not-required"],
 *     }],
 * });
 * const testStaticIp = new aws.lightsail.StaticIp("test", {name: "test-static-ip"});
 * const testInstance = new aws.lightsail.Instance("test", {
 *     name: "test-instance",
 *     availabilityZone: available.then(available => available.names?.[0]),
 *     blueprintId: "amazon_linux_2",
 *     bundleId: "micro_1_0",
 * });
 * const test = new aws.lightsail.StaticIpAttachment("test", {
 *     staticIpName: testStaticIp.name,
 *     instanceName: testInstance.name,
 * });
 * const testDistribution = new aws.lightsail.Distribution("test", {
 *     name: "test-distribution",
 *     bundleId: "small_1_0",
 *     origin: {
 *         name: testInstance.name,
 *         regionName: available.then(available => available.id),
 *     },
 *     defaultCacheBehavior: {
 *         behavior: "cache",
 *     },
 * }, {
 *     dependsOn: [test],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * available = aws.get_availability_zones(state="available",
 *     filters=[{
 *         "name": "opt-in-status",
 *         "values": ["opt-in-not-required"],
 *     }])
 * test_static_ip = aws.lightsail.StaticIp("test", name="test-static-ip")
 * test_instance = aws.lightsail.Instance("test",
 *     name="test-instance",
 *     availability_zone=available.names[0],
 *     blueprint_id="amazon_linux_2",
 *     bundle_id="micro_1_0")
 * test = aws.lightsail.StaticIpAttachment("test",
 *     static_ip_name=test_static_ip.name,
 *     instance_name=test_instance.name)
 * test_distribution = aws.lightsail.Distribution("test",
 *     name="test-distribution",
 *     bundle_id="small_1_0",
 *     origin={
 *         "name": test_instance.name,
 *         "region_name": available.id,
 *     },
 *     default_cache_behavior={
 *         "behavior": "cache",
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[test]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var available = Aws.GetAvailabilityZones.Invoke(new()
 *     {
 *         State = "available",
 *         Filters = new[]
 *         {
 *             new Aws.Inputs.GetAvailabilityZonesFilterInputArgs
 *             {
 *                 Name = "opt-in-status",
 *                 Values = new[]
 *                 {
 *                     "opt-in-not-required",
 *                 },
 *             },
 *         },
 *     });
 *     var testStaticIp = new Aws.LightSail.StaticIp("test", new()
 *     {
 *         Name = "test-static-ip",
 *     });
 *     var testInstance = new Aws.LightSail.Instance("test", new()
 *     {
 *         Name = "test-instance",
 *         AvailabilityZone = available.Apply(getAvailabilityZonesResult => getAvailabilityZonesResult.Names[0]),
 *         BlueprintId = "amazon_linux_2",
 *         BundleId = "micro_1_0",
 *     });
 *     var test = new Aws.LightSail.StaticIpAttachment("test", new()
 *     {
 *         StaticIpName = testStaticIp.Name,
 *         InstanceName = testInstance.Name,
 *     });
 *     var testDistribution = new Aws.LightSail.Distribution("test", new()
 *     {
 *         Name = "test-distribution",
 *         BundleId = "small_1_0",
 *         Origin = new Aws.LightSail.Inputs.DistributionOriginArgs
 *         {
 *             Name = testInstance.Name,
 *             RegionName = available.Apply(getAvailabilityZonesResult => getAvailabilityZonesResult.Id),
 *         },
 *         DefaultCacheBehavior = new Aws.LightSail.Inputs.DistributionDefaultCacheBehaviorArgs
 *         {
 *             Behavior = "cache",
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             test,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		available, err := aws.GetAvailabilityZones(ctx, &aws.GetAvailabilityZonesArgs{
 * 			State: pulumi.StringRef("available"),
 * 			Filters: []aws.GetAvailabilityZonesFilter{
 * 				{
 * 					Name: "opt-in-status",
 * 					Values: []string{
 * 						"opt-in-not-required",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testStaticIp, err := lightsail.NewStaticIp(ctx, "test", &lightsail.StaticIpArgs{
 * 			Name: pulumi.String("test-static-ip"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testInstance, err := lightsail.NewInstance(ctx, "test", &lightsail.InstanceArgs{
 * 			Name:             pulumi.String("test-instance"),
 * 			AvailabilityZone: pulumi.String(available.Names[0]),
 * 			BlueprintId:      pulumi.String("amazon_linux_2"),
 * 			BundleId:         pulumi.String("micro_1_0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		test, err := lightsail.NewStaticIpAttachment(ctx, "test", &lightsail.StaticIpAttachmentArgs{
 * 			StaticIpName: testStaticIp.Name,
 * 			InstanceName: testInstance.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lightsail.NewDistribution(ctx, "test", &lightsail.DistributionArgs{
 * 			Name:     pulumi.String("test-distribution"),
 * 			BundleId: pulumi.String("small_1_0"),
 * 			Origin: &lightsail.DistributionOriginArgs{
 * 				Name:       testInstance.Name,
 * 				RegionName: pulumi.String(available.Id),
 * 			},
 * 			DefaultCacheBehavior: &lightsail.DistributionDefaultCacheBehaviorArgs{
 * 				Behavior: pulumi.String("cache"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			test,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.lightsail.StaticIp;
 * import com.pulumi.aws.lightsail.StaticIpArgs;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import com.pulumi.aws.lightsail.StaticIpAttachment;
 * import com.pulumi.aws.lightsail.StaticIpAttachmentArgs;
 * import com.pulumi.aws.lightsail.Distribution;
 * import com.pulumi.aws.lightsail.DistributionArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionOriginArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionDefaultCacheBehaviorArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
 *             .state("available")
 *             .filters(GetAvailabilityZonesFilterArgs.builder()
 *                 .name("opt-in-status")
 *                 .values("opt-in-not-required")
 *                 .build())
 *             .build());
 *         var testStaticIp = new StaticIp("testStaticIp", StaticIpArgs.builder()
 *             .name("test-static-ip")
 *             .build());
 *         var testInstance = new Instance("testInstance", InstanceArgs.builder()
 *             .name("test-instance")
 *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]))
 *             .blueprintId("amazon_linux_2")
 *             .bundleId("micro_1_0")
 *             .build());
 *         var test = new StaticIpAttachment("test", StaticIpAttachmentArgs.builder()
 *             .staticIpName(testStaticIp.name())
 *             .instanceName(testInstance.name())
 *             .build());
 *         var testDistribution = new Distribution("testDistribution", DistributionArgs.builder()
 *             .name("test-distribution")
 *             .bundleId("small_1_0")
 *             .origin(DistributionOriginArgs.builder()
 *                 .name(testInstance.name())
 *                 .regionName(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.id()))
 *                 .build())
 *             .defaultCacheBehavior(DistributionDefaultCacheBehaviorArgs.builder()
 *                 .behavior("cache")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(test)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:lightsail:StaticIpAttachment
 *     properties:
 *       staticIpName: ${testStaticIp.name}
 *       instanceName: ${testInstance.name}
 *   testStaticIp:
 *     type: aws:lightsail:StaticIp
 *     name: test
 *     properties:
 *       name: test-static-ip
 *   testInstance:
 *     type: aws:lightsail:Instance
 *     name: test
 *     properties:
 *       name: test-instance
 *       availabilityZone: ${available.names[0]}
 *       blueprintId: amazon_linux_2
 *       bundleId: micro_1_0
 *   testDistribution:
 *     type: aws:lightsail:Distribution
 *     name: test
 *     properties:
 *       name: test-distribution
 *       bundleId: small_1_0
 *       origin:
 *         name: ${testInstance.name}
 *         regionName: ${available.id}
 *       defaultCacheBehavior:
 *         behavior: cache
 *     options:
 *       dependson:
 *         - ${test}
 * variables:
 *   available:
 *     fn::invoke:
 *       Function: aws:getAvailabilityZones
 *       Arguments:
 *         state: available
 *         filters:
 *           - name: opt-in-status
 *             values:
 *               - opt-in-not-required
 * ```
 * <!--End PulumiCodeChooser -->
 * ### lb origin example
 * Below is an example with a load balancer as an origin
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const available = aws.getAvailabilityZones({
 *     state: "available",
 *     filters: [{
 *         name: "opt-in-status",
 *         values: ["opt-in-not-required"],
 *     }],
 * });
 * const test = new aws.lightsail.Lb("test", {
 *     name: "test-load-balancer",
 *     healthCheckPath: "/",
 *     instancePort: 80,
 *     tags: {
 *         foo: "bar",
 *     },
 * });
 * const testInstance = new aws.lightsail.Instance("test", {
 *     name: "test-instance",
 *     availabilityZone: available.then(available => available.names?.[0]),
 *     blueprintId: "amazon_linux_2",
 *     bundleId: "nano_3_0",
 * });
 * const testLbAttachment = new aws.lightsail.LbAttachment("test", {
 *     lbName: test.name,
 *     instanceName: testInstance.name,
 * });
 * const testDistribution = new aws.lightsail.Distribution("test", {
 *     name: "test-distribution",
 *     bundleId: "small_1_0",
 *     origin: {
 *         name: test.name,
 *         regionName: available.then(available => available.id),
 *     },
 *     defaultCacheBehavior: {
 *         behavior: "cache",
 *     },
 * }, {
 *     dependsOn: [testLbAttachment],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * available = aws.get_availability_zones(state="available",
 *     filters=[{
 *         "name": "opt-in-status",
 *         "values": ["opt-in-not-required"],
 *     }])
 * test = aws.lightsail.Lb("test",
 *     name="test-load-balancer",
 *     health_check_path="/",
 *     instance_port=80,
 *     tags={
 *         "foo": "bar",
 *     })
 * test_instance = aws.lightsail.Instance("test",
 *     name="test-instance",
 *     availability_zone=available.names[0],
 *     blueprint_id="amazon_linux_2",
 *     bundle_id="nano_3_0")
 * test_lb_attachment = aws.lightsail.LbAttachment("test",
 *     lb_name=test.name,
 *     instance_name=test_instance.name)
 * test_distribution = aws.lightsail.Distribution("test",
 *     name="test-distribution",
 *     bundle_id="small_1_0",
 *     origin={
 *         "name": test.name,
 *         "region_name": available.id,
 *     },
 *     default_cache_behavior={
 *         "behavior": "cache",
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[test_lb_attachment]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var available = Aws.GetAvailabilityZones.Invoke(new()
 *     {
 *         State = "available",
 *         Filters = new[]
 *         {
 *             new Aws.Inputs.GetAvailabilityZonesFilterInputArgs
 *             {
 *                 Name = "opt-in-status",
 *                 Values = new[]
 *                 {
 *                     "opt-in-not-required",
 *                 },
 *             },
 *         },
 *     });
 *     var test = new Aws.LightSail.Lb("test", new()
 *     {
 *         Name = "test-load-balancer",
 *         HealthCheckPath = "/",
 *         InstancePort = 80,
 *         Tags =
 *         {
 *             { "foo", "bar" },
 *         },
 *     });
 *     var testInstance = new Aws.LightSail.Instance("test", new()
 *     {
 *         Name = "test-instance",
 *         AvailabilityZone = available.Apply(getAvailabilityZonesResult => getAvailabilityZonesResult.Names[0]),
 *         BlueprintId = "amazon_linux_2",
 *         BundleId = "nano_3_0",
 *     });
 *     var testLbAttachment = new Aws.LightSail.LbAttachment("test", new()
 *     {
 *         LbName = test.Name,
 *         InstanceName = testInstance.Name,
 *     });
 *     var testDistribution = new Aws.LightSail.Distribution("test", new()
 *     {
 *         Name = "test-distribution",
 *         BundleId = "small_1_0",
 *         Origin = new Aws.LightSail.Inputs.DistributionOriginArgs
 *         {
 *             Name = test.Name,
 *             RegionName = available.Apply(getAvailabilityZonesResult => getAvailabilityZonesResult.Id),
 *         },
 *         DefaultCacheBehavior = new Aws.LightSail.Inputs.DistributionDefaultCacheBehaviorArgs
 *         {
 *             Behavior = "cache",
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             testLbAttachment,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		available, err := aws.GetAvailabilityZones(ctx, &aws.GetAvailabilityZonesArgs{
 * 			State: pulumi.StringRef("available"),
 * 			Filters: []aws.GetAvailabilityZonesFilter{
 * 				{
 * 					Name: "opt-in-status",
 * 					Values: []string{
 * 						"opt-in-not-required",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		test, err := lightsail.NewLb(ctx, "test", &lightsail.LbArgs{
 * 			Name:            pulumi.String("test-load-balancer"),
 * 			HealthCheckPath: pulumi.String("/"),
 * 			InstancePort:    pulumi.Int(80),
 * 			Tags: pulumi.StringMap{
 * 				"foo": pulumi.String("bar"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testInstance, err := lightsail.NewInstance(ctx, "test", &lightsail.InstanceArgs{
 * 			Name:             pulumi.String("test-instance"),
 * 			AvailabilityZone: pulumi.String(available.Names[0]),
 * 			BlueprintId:      pulumi.String("amazon_linux_2"),
 * 			BundleId:         pulumi.String("nano_3_0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testLbAttachment, err := lightsail.NewLbAttachment(ctx, "test", &lightsail.LbAttachmentArgs{
 * 			LbName:       test.Name,
 * 			InstanceName: testInstance.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lightsail.NewDistribution(ctx, "test", &lightsail.DistributionArgs{
 * 			Name:     pulumi.String("test-distribution"),
 * 			BundleId: pulumi.String("small_1_0"),
 * 			Origin: &lightsail.DistributionOriginArgs{
 * 				Name:       test.Name,
 * 				RegionName: pulumi.String(available.Id),
 * 			},
 * 			DefaultCacheBehavior: &lightsail.DistributionDefaultCacheBehaviorArgs{
 * 				Behavior: pulumi.String("cache"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			testLbAttachment,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.lightsail.Lb;
 * import com.pulumi.aws.lightsail.LbArgs;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import com.pulumi.aws.lightsail.LbAttachment;
 * import com.pulumi.aws.lightsail.LbAttachmentArgs;
 * import com.pulumi.aws.lightsail.Distribution;
 * import com.pulumi.aws.lightsail.DistributionArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionOriginArgs;
 * import com.pulumi.aws.lightsail.inputs.DistributionDefaultCacheBehaviorArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
 *             .state("available")
 *             .filters(GetAvailabilityZonesFilterArgs.builder()
 *                 .name("opt-in-status")
 *                 .values("opt-in-not-required")
 *                 .build())
 *             .build());
 *         var test = new Lb("test", LbArgs.builder()
 *             .name("test-load-balancer")
 *             .healthCheckPath("/")
 *             .instancePort("80")
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *         var testInstance = new Instance("testInstance", InstanceArgs.builder()
 *             .name("test-instance")
 *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]))
 *             .blueprintId("amazon_linux_2")
 *             .bundleId("nano_3_0")
 *             .build());
 *         var testLbAttachment = new LbAttachment("testLbAttachment", LbAttachmentArgs.builder()
 *             .lbName(test.name())
 *             .instanceName(testInstance.name())
 *             .build());
 *         var testDistribution = new Distribution("testDistribution", DistributionArgs.builder()
 *             .name("test-distribution")
 *             .bundleId("small_1_0")
 *             .origin(DistributionOriginArgs.builder()
 *                 .name(test.name())
 *                 .regionName(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.id()))
 *                 .build())
 *             .defaultCacheBehavior(DistributionDefaultCacheBehaviorArgs.builder()
 *                 .behavior("cache")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(testLbAttachment)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:lightsail:Lb
 *     properties:
 *       name: test-load-balancer
 *       healthCheckPath: /
 *       instancePort: '80'
 *       tags:
 *         foo: bar
 *   testInstance:
 *     type: aws:lightsail:Instance
 *     name: test
 *     properties:
 *       name: test-instance
 *       availabilityZone: ${available.names[0]}
 *       blueprintId: amazon_linux_2
 *       bundleId: nano_3_0
 *   testLbAttachment:
 *     type: aws:lightsail:LbAttachment
 *     name: test
 *     properties:
 *       lbName: ${test.name}
 *       instanceName: ${testInstance.name}
 *   testDistribution:
 *     type: aws:lightsail:Distribution
 *     name: test
 *     properties:
 *       name: test-distribution
 *       bundleId: small_1_0
 *       origin:
 *         name: ${test.name}
 *         regionName: ${available.id}
 *       defaultCacheBehavior:
 *         behavior: cache
 *     options:
 *       dependson:
 *         - ${testLbAttachment}
 * variables:
 *   available:
 *     fn::invoke:
 *       Function: aws:getAvailabilityZones
 *       Arguments:
 *         state: available
 *         filters:
 *           - name: opt-in-status
 *             values:
 *               - opt-in-not-required
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Lightsail Distribution using the `id`. For example:
 * ```sh
 * $ pulumi import aws:lightsail/distribution:Distribution example rft-8012925589
 * ```
 */
public class Distribution internal constructor(
    override val javaResource: com.pulumi.aws.lightsail.Distribution,
) : KotlinCustomResource(javaResource, DistributionMapper) {
    /**
     * The alternate domain names of the distribution.
     */
    public val alternativeDomainNames: Output<List<String>>
        get() = javaResource.alternativeDomainNames().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The Amazon Resource Name (ARN) of the distribution.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Bundle ID to use for the distribution.
     */
    public val bundleId: Output<String>
        get() = javaResource.bundleId().applyValue({ args0 -> args0 })

    /**
     * An object that describes the cache behavior settings of the distribution. Detailed below
     * The following arguments are optional:
     */
    public val cacheBehaviorSettings: Output<DistributionCacheBehaviorSettings>?
        get() = javaResource.cacheBehaviorSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> distributionCacheBehaviorSettingsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A set of configuration blocks that describe the per-path cache behavior of the distribution. Detailed below
     */
    public val cacheBehaviors: Output<List<DistributionCacheBehavior>>?
        get() = javaResource.cacheBehaviors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        distributionCacheBehaviorToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The name of the SSL/TLS certificate attached to the distribution, if any.
     */
    public val certificateName: Output<String>?
        get() = javaResource.certificateName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The timestamp when the distribution was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * Object that describes the default cache behavior of the distribution. Detailed below
     */
    public val defaultCacheBehavior: Output<DistributionDefaultCacheBehavior>
        get() = javaResource.defaultCacheBehavior().applyValue({ args0 ->
            args0.let({ args0 ->
                distributionDefaultCacheBehaviorToKotlin(args0)
            })
        })

    /**
     * The domain name of the distribution.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * The IP address type of the distribution. Default: `dualstack`.
     */
    public val ipAddressType: Output<String>?
        get() = javaResource.ipAddressType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether the distribution is enabled. Default: `true`.
     */
    public val isEnabled: Output<Boolean>?
        get() = javaResource.isEnabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * An object that describes the location of the distribution, such as the AWS Region and Availability Zone. Detailed below
     */
    public val locations: Output<List<DistributionLocation>>
        get() = javaResource.locations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    distributionLocationToKotlin(args0)
                })
            })
        })

    /**
     * Name of the distribution.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Object that describes the origin resource of the distribution, such as a Lightsail instance, bucket, or load balancer. Detailed below
     */
    public val origin: Output<DistributionOrigin>
        get() = javaResource.origin().applyValue({ args0 ->
            args0.let({ args0 ->
                distributionOriginToKotlin(args0)
            })
        })

    /**
     * The public DNS of the origin.
     */
    public val originPublicDns: Output<String>
        get() = javaResource.originPublicDns().applyValue({ args0 -> args0 })

    /**
     * The Lightsail resource type (e.g., Distribution).
     */
    public val resourceType: Output<String>
        get() = javaResource.resourceType().applyValue({ args0 -> args0 })

    /**
     * The status of the distribution.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The support code. Include this code in your email to support when you have questions about your Lightsail distribution. This code enables our support team to look up your Lightsail information more easily.
     */
    public val supportCode: Output<String>
        get() = javaResource.supportCode().applyValue({ args0 -> args0 })

    /**
     * Map of tags for the Lightsail Distribution. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object DistributionMapper : ResourceMapper<Distribution> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lightsail.Distribution::class == javaResource::class

    override fun map(javaResource: Resource): Distribution = Distribution(
        javaResource as
            com.pulumi.aws.lightsail.Distribution,
    )
}

/**
 * @see [Distribution].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Distribution].
 */
public suspend fun distribution(
    name: String,
    block: suspend DistributionResourceBuilder.() -> Unit,
): Distribution {
    val builder = DistributionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Distribution].
 * @param name The _unique_ name of the resulting resource.
 */
public fun distribution(name: String): Distribution {
    val builder = DistributionResourceBuilder()
    builder.name(name)
    return builder.build()
}
