@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.DomainEntryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Creates a domain entry resource
 * > **NOTE on `id`:** In an effort to simplify imports, this resource `id` field has been updated to the standard resource id separator, a comma (`,`). For backward compatibility, the previous separator (underscore `_`) can still be used to read and import existing resources. When state is refreshed, the `id` will be updated to use the new standard separator. The previous separator will be deprecated in a future major release.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.lightsail.Domain("test", {domainName: "mydomain.com"});
 * const testDomainEntry = new aws.lightsail.DomainEntry("test", {
 *     domainName: domainTest.domainName,
 *     name: "www",
 *     type: "A",
 *     target: "127.0.0.1",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.lightsail.Domain("test", domain_name="mydomain.com")
 * test_domain_entry = aws.lightsail.DomainEntry("test",
 *     domain_name=domain_test["domainName"],
 *     name="www",
 *     type="A",
 *     target="127.0.0.1")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.LightSail.Domain("test", new()
 *     {
 *         DomainName = "mydomain.com",
 *     });
 *     var testDomainEntry = new Aws.LightSail.DomainEntry("test", new()
 *     {
 *         DomainName = domainTest.DomainName,
 *         Name = "www",
 *         Type = "A",
 *         Target = "127.0.0.1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lightsail.NewDomain(ctx, "test", &lightsail.DomainArgs{
 * 			DomainName: pulumi.String("mydomain.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lightsail.NewDomainEntry(ctx, "test", &lightsail.DomainEntryArgs{
 * 			DomainName: pulumi.Any(domainTest.DomainName),
 * 			Name:       pulumi.String("www"),
 * 			Type:       pulumi.String("A"),
 * 			Target:     pulumi.String("127.0.0.1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Domain;
 * import com.pulumi.aws.lightsail.DomainArgs;
 * import com.pulumi.aws.lightsail.DomainEntry;
 * import com.pulumi.aws.lightsail.DomainEntryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Domain("test", DomainArgs.builder()
 *             .domainName("mydomain.com")
 *             .build());
 *         var testDomainEntry = new DomainEntry("testDomainEntry", DomainEntryArgs.builder()
 *             .domainName(domainTest.domainName())
 *             .name("www")
 *             .type("A")
 *             .target("127.0.0.1")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:lightsail:Domain
 *     properties:
 *       domainName: mydomain.com
 *   testDomainEntry:
 *     type: aws:lightsail:DomainEntry
 *     name: test
 *     properties:
 *       domainName: ${domainTest.domainName}
 *       name: www
 *       type: A
 *       target: 127.0.0.1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_domain_entry` using the id attribute. For example:
 * ```sh
 * $ pulumi import aws:lightsail/domainEntry:DomainEntry example www,mydomain.com,A,127.0.0.1
 * ```
 * @property domainName The name of the Lightsail domain in which to create the entry
 * @property isAlias If the entry should be an alias Defaults to `false`
 * @property name Name of the entry record
 * @property target Target of the domain entry
 * @property type Type of record
 */
public data class DomainEntryArgs(
    public val domainName: Output<String>? = null,
    public val isAlias: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val target: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.DomainEntryArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.DomainEntryArgs =
        com.pulumi.aws.lightsail.DomainEntryArgs.builder()
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .isAlias(isAlias?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .target(target?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainEntryArgs].
 */
@PulumiTagMarker
public class DomainEntryArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    private var isAlias: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var target: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The name of the Lightsail domain in which to create the entry
     */
    @JvmName("omjiqbqovclqgpya")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value If the entry should be an alias Defaults to `false`
     */
    @JvmName("ksfjlxhsnynjutas")
    public suspend fun isAlias(`value`: Output<Boolean>) {
        this.isAlias = value
    }

    /**
     * @param value Name of the entry record
     */
    @JvmName("chmrnewroibbajqm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Target of the domain entry
     */
    @JvmName("amrxbjxlqxldpdog")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value Type of record
     */
    @JvmName("ikneurnjnkodwxrh")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The name of the Lightsail domain in which to create the entry
     */
    @JvmName("yxggjglvpsrvaixg")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value If the entry should be an alias Defaults to `false`
     */
    @JvmName("nshgmfgfqvdotgbj")
    public suspend fun isAlias(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isAlias = mapped
    }

    /**
     * @param value Name of the entry record
     */
    @JvmName("hsxfclkuuhfdbckx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Target of the domain entry
     */
    @JvmName("vnusdrsptywdggcf")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param value Type of record
     */
    @JvmName("xbwbpyqpfnxrftbe")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DomainEntryArgs = DomainEntryArgs(
        domainName = domainName,
        isAlias = isAlias,
        name = name,
        target = target,
        type = type,
    )
}
