@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.kotlin.outputs.InstanceAddOn
import com.pulumi.aws.lightsail.kotlin.outputs.InstanceAddOn.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource = com.pulumi.aws.lightsail.Instance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Instance(builtJavaResource)
    }
}

/**
 * Provides a Lightsail Instance. Amazon Lightsail is a service to provide easy virtual private servers
 * with custom software already setup. See [What is Amazon Lightsail?](https://lightsail.aws.amazon.com/ls/docs/getting-started/article/what-is-amazon-lightsail)
 * for more information.
 * > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail) for more details
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * // Create a new GitLab Lightsail Instance
 * const gitlabTest = new aws.lightsail.Instance("gitlab_test", {
 *     name: "custom_gitlab",
 *     availabilityZone: "us-east-1b",
 *     blueprintId: "amazon_linux_2",
 *     bundleId: "nano_3_0",
 *     keyPairName: "some_key_name",
 *     tags: {
 *         foo: "bar",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * # Create a new GitLab Lightsail Instance
 * gitlab_test = aws.lightsail.Instance("gitlab_test",
 *     name="custom_gitlab",
 *     availability_zone="us-east-1b",
 *     blueprint_id="amazon_linux_2",
 *     bundle_id="nano_3_0",
 *     key_pair_name="some_key_name",
 *     tags={
 *         "foo": "bar",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a new GitLab Lightsail Instance
 *     var gitlabTest = new Aws.LightSail.Instance("gitlab_test", new()
 *     {
 *         Name = "custom_gitlab",
 *         AvailabilityZone = "us-east-1b",
 *         BlueprintId = "amazon_linux_2",
 *         BundleId = "nano_3_0",
 *         KeyPairName = "some_key_name",
 *         Tags =
 *         {
 *             { "foo", "bar" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a new GitLab Lightsail Instance
 * 		_, err := lightsail.NewInstance(ctx, "gitlab_test", &lightsail.InstanceArgs{
 * 			Name:             pulumi.String("custom_gitlab"),
 * 			AvailabilityZone: pulumi.String("us-east-1b"),
 * 			BlueprintId:      pulumi.String("amazon_linux_2"),
 * 			BundleId:         pulumi.String("nano_3_0"),
 * 			KeyPairName:      pulumi.String("some_key_name"),
 * 			Tags: pulumi.StringMap{
 * 				"foo": pulumi.String("bar"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a new GitLab Lightsail Instance
 *         var gitlabTest = new Instance("gitlabTest", InstanceArgs.builder()
 *             .name("custom_gitlab")
 *             .availabilityZone("us-east-1b")
 *             .blueprintId("amazon_linux_2")
 *             .bundleId("nano_3_0")
 *             .keyPairName("some_key_name")
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a new GitLab Lightsail Instance
 *   gitlabTest:
 *     type: aws:lightsail:Instance
 *     name: gitlab_test
 *     properties:
 *       name: custom_gitlab
 *       availabilityZone: us-east-1b
 *       blueprintId: amazon_linux_2
 *       bundleId: nano_3_0
 *       keyPairName: some_key_name
 *       tags:
 *         foo: bar
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Example With User Data
 * Lightsail user data is handled differently than ec2 user data. Lightsail user data only accepts a single lined string. The below example shows installing apache and creating the index page.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const custom = new aws.lightsail.Instance("custom", {
 *     name: "custom",
 *     availabilityZone: "us-east-1b",
 *     blueprintId: "amazon_linux_2",
 *     bundleId: "nano_3_0",
 *     userData: "sudo yum install -y httpd && sudo systemctl start httpd && sudo systemctl enable httpd && echo '<h1>Deployed via Pulumi</h1>' | sudo tee /var/www/html/index.html",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * custom = aws.lightsail.Instance("custom",
 *     name="custom",
 *     availability_zone="us-east-1b",
 *     blueprint_id="amazon_linux_2",
 *     bundle_id="nano_3_0",
 *     user_data="sudo yum install -y httpd && sudo systemctl start httpd && sudo systemctl enable httpd && echo '<h1>Deployed via Pulumi</h1>' | sudo tee /var/www/html/index.html")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var custom = new Aws.LightSail.Instance("custom", new()
 *     {
 *         Name = "custom",
 *         AvailabilityZone = "us-east-1b",
 *         BlueprintId = "amazon_linux_2",
 *         BundleId = "nano_3_0",
 *         UserData = "sudo yum install -y httpd && sudo systemctl start httpd && sudo systemctl enable httpd && echo '<h1>Deployed via Pulumi</h1>' | sudo tee /var/www/html/index.html",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lightsail.NewInstance(ctx, "custom", &lightsail.InstanceArgs{
 * 			Name:             pulumi.String("custom"),
 * 			AvailabilityZone: pulumi.String("us-east-1b"),
 * 			BlueprintId:      pulumi.String("amazon_linux_2"),
 * 			BundleId:         pulumi.String("nano_3_0"),
 * 			UserData:         pulumi.String("sudo yum install -y httpd && sudo systemctl start httpd && sudo systemctl enable httpd && echo '<h1>Deployed via Pulumi</h1>' | sudo tee /var/www/html/index.html"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var custom = new Instance("custom", InstanceArgs.builder()
 *             .name("custom")
 *             .availabilityZone("us-east-1b")
 *             .blueprintId("amazon_linux_2")
 *             .bundleId("nano_3_0")
 *             .userData("sudo yum install -y httpd && sudo systemctl start httpd && sudo systemctl enable httpd && echo '<h1>Deployed via Pulumi</h1>' | sudo tee /var/www/html/index.html")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   custom:
 *     type: aws:lightsail:Instance
 *     properties:
 *       name: custom
 *       availabilityZone: us-east-1b
 *       blueprintId: amazon_linux_2
 *       bundleId: nano_3_0
 *       userData: sudo yum install -y httpd && sudo systemctl start httpd && sudo systemctl enable httpd && echo '<h1>Deployed via Pulumi</h1>' | sudo tee /var/www/html/index.html
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Enable Auto Snapshots
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.lightsail.Instance("test", {
 *     name: "custom_instance",
 *     availabilityZone: "us-east-1b",
 *     blueprintId: "amazon_linux_2",
 *     bundleId: "nano_3_0",
 *     addOn: {
 *         type: "AutoSnapshot",
 *         snapshotTime: "06:00",
 *         status: "Enabled",
 *     },
 *     tags: {
 *         foo: "bar",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.lightsail.Instance("test",
 *     name="custom_instance",
 *     availability_zone="us-east-1b",
 *     blueprint_id="amazon_linux_2",
 *     bundle_id="nano_3_0",
 *     add_on={
 *         "type": "AutoSnapshot",
 *         "snapshot_time": "06:00",
 *         "status": "Enabled",
 *     },
 *     tags={
 *         "foo": "bar",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.LightSail.Instance("test", new()
 *     {
 *         Name = "custom_instance",
 *         AvailabilityZone = "us-east-1b",
 *         BlueprintId = "amazon_linux_2",
 *         BundleId = "nano_3_0",
 *         AddOn = new Aws.LightSail.Inputs.InstanceAddOnArgs
 *         {
 *             Type = "AutoSnapshot",
 *             SnapshotTime = "06:00",
 *             Status = "Enabled",
 *         },
 *         Tags =
 *         {
 *             { "foo", "bar" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lightsail.NewInstance(ctx, "test", &lightsail.InstanceArgs{
 * 			Name:             pulumi.String("custom_instance"),
 * 			AvailabilityZone: pulumi.String("us-east-1b"),
 * 			BlueprintId:      pulumi.String("amazon_linux_2"),
 * 			BundleId:         pulumi.String("nano_3_0"),
 * 			AddOn: &lightsail.InstanceAddOnArgs{
 * 				Type:         pulumi.String("AutoSnapshot"),
 * 				SnapshotTime: pulumi.String("06:00"),
 * 				Status:       pulumi.String("Enabled"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"foo": pulumi.String("bar"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import com.pulumi.aws.lightsail.inputs.InstanceAddOnArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Instance("test", InstanceArgs.builder()
 *             .name("custom_instance")
 *             .availabilityZone("us-east-1b")
 *             .blueprintId("amazon_linux_2")
 *             .bundleId("nano_3_0")
 *             .addOn(InstanceAddOnArgs.builder()
 *                 .type("AutoSnapshot")
 *                 .snapshotTime("06:00")
 *                 .status("Enabled")
 *                 .build())
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:lightsail:Instance
 *     properties:
 *       name: custom_instance
 *       availabilityZone: us-east-1b
 *       blueprintId: amazon_linux_2
 *       bundleId: nano_3_0
 *       addOn:
 *         type: AutoSnapshot
 *         snapshotTime: 06:00
 *         status: Enabled
 *       tags:
 *         foo: bar
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Lightsail Instances using their name. For example:
 * ```sh
 * $ pulumi import aws:lightsail/instance:Instance gitlab_test 'custom_gitlab'
 * ```
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.aws.lightsail.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * The add on configuration for the instance. Detailed below.
     */
    public val addOn: Output<InstanceAddOn>?
        get() = javaResource.addOn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The ARN of the Lightsail instance (matches `id`).
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The Availability Zone in which to create your instance. A
     * list of available zones can be obtained using the AWS CLI command:
     * [`aws lightsail get-regions --include-availability-zones`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-regions.html).
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * The ID for a virtual private server image. A list of available
     * blueprint IDs can be obtained using the AWS CLI command:
     * [`aws lightsail get-blueprints`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-blueprints.html).
     */
    public val blueprintId: Output<String>
        get() = javaResource.blueprintId().applyValue({ args0 -> args0 })

    /**
     * The bundle of specification information. A list of available
     * bundle IDs can be obtained using the AWS CLI command:
     * [`aws lightsail get-bundles`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-bundles.html).
     */
    public val bundleId: Output<String>
        get() = javaResource.bundleId().applyValue({ args0 -> args0 })

    /**
     * The number of vCPUs the instance has.
     */
    public val cpuCount: Output<Int>
        get() = javaResource.cpuCount().applyValue({ args0 -> args0 })

    /**
     * The timestamp when the instance was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * The IP address type of the Lightsail Instance. Valid Values: `dualstack` | `ipv4`.
     */
    public val ipAddressType: Output<String>?
        get() = javaResource.ipAddressType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of IPv6 addresses for the Lightsail instance.
     */
    public val ipv6Addresses: Output<List<String>>
        get() = javaResource.ipv6Addresses().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A Boolean value indicating whether this instance has a static IP assigned to it.
     */
    public val isStaticIp: Output<Boolean>
        get() = javaResource.isStaticIp().applyValue({ args0 -> args0 })

    /**
     * The name of your key pair. Created in the
     * Lightsail console (cannot use `aws.ec2.KeyPair` at this time)
     */
    public val keyPairName: Output<String>?
        get() = javaResource.keyPairName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the Lightsail Instance. Names must be unique within each AWS Region in your Lightsail account.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The private IP address of the instance.
     */
    public val privateIpAddress: Output<String>
        get() = javaResource.privateIpAddress().applyValue({ args0 -> args0 })

    /**
     * The public IP address of the instance.
     */
    public val publicIpAddress: Output<String>
        get() = javaResource.publicIpAddress().applyValue({ args0 -> args0 })

    /**
     * The amount of RAM in GB on the instance (e.g., 1.0).
     */
    public val ramSize: Output<Double>
        get() = javaResource.ramSize().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Single lined launch script as a string to configure server with additional user data
     */
    public val userData: Output<String>?
        get() = javaResource.userData().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The user name for connecting to the instance (e.g., ec2-user).
     */
    public val username: Output<String>
        get() = javaResource.username().applyValue({ args0 -> args0 })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lightsail.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.aws.lightsail.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
