@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.InstanceArgs.builder
import com.pulumi.aws.lightsail.kotlin.inputs.InstanceAddOnArgs
import com.pulumi.aws.lightsail.kotlin.inputs.InstanceAddOnArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Lightsail Instance. Amazon Lightsail is a service to provide easy virtual private servers
 * with custom software already setup. See [What is Amazon Lightsail?](https://lightsail.aws.amazon.com/ls/docs/getting-started/article/what-is-amazon-lightsail)
 * for more information.
 * > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail) for more details
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * // Create a new GitLab Lightsail Instance
 * const gitlabTest = new aws.lightsail.Instance("gitlab_test", {
 *     name: "custom_gitlab",
 *     availabilityZone: "us-east-1b",
 *     blueprintId: "amazon_linux_2",
 *     bundleId: "nano_3_0",
 *     keyPairName: "some_key_name",
 *     tags: {
 *         foo: "bar",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * # Create a new GitLab Lightsail Instance
 * gitlab_test = aws.lightsail.Instance("gitlab_test",
 *     name="custom_gitlab",
 *     availability_zone="us-east-1b",
 *     blueprint_id="amazon_linux_2",
 *     bundle_id="nano_3_0",
 *     key_pair_name="some_key_name",
 *     tags={
 *         "foo": "bar",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a new GitLab Lightsail Instance
 *     var gitlabTest = new Aws.LightSail.Instance("gitlab_test", new()
 *     {
 *         Name = "custom_gitlab",
 *         AvailabilityZone = "us-east-1b",
 *         BlueprintId = "amazon_linux_2",
 *         BundleId = "nano_3_0",
 *         KeyPairName = "some_key_name",
 *         Tags =
 *         {
 *             { "foo", "bar" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a new GitLab Lightsail Instance
 * 		_, err := lightsail.NewInstance(ctx, "gitlab_test", &lightsail.InstanceArgs{
 * 			Name:             pulumi.String("custom_gitlab"),
 * 			AvailabilityZone: pulumi.String("us-east-1b"),
 * 			BlueprintId:      pulumi.String("amazon_linux_2"),
 * 			BundleId:         pulumi.String("nano_3_0"),
 * 			KeyPairName:      pulumi.String("some_key_name"),
 * 			Tags: pulumi.StringMap{
 * 				"foo": pulumi.String("bar"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a new GitLab Lightsail Instance
 *         var gitlabTest = new Instance("gitlabTest", InstanceArgs.builder()
 *             .name("custom_gitlab")
 *             .availabilityZone("us-east-1b")
 *             .blueprintId("amazon_linux_2")
 *             .bundleId("nano_3_0")
 *             .keyPairName("some_key_name")
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a new GitLab Lightsail Instance
 *   gitlabTest:
 *     type: aws:lightsail:Instance
 *     name: gitlab_test
 *     properties:
 *       name: custom_gitlab
 *       availabilityZone: us-east-1b
 *       blueprintId: amazon_linux_2
 *       bundleId: nano_3_0
 *       keyPairName: some_key_name
 *       tags:
 *         foo: bar
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Example With User Data
 * Lightsail user data is handled differently than ec2 user data. Lightsail user data only accepts a single lined string. The below example shows installing apache and creating the index page.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const custom = new aws.lightsail.Instance("custom", {
 *     name: "custom",
 *     availabilityZone: "us-east-1b",
 *     blueprintId: "amazon_linux_2",
 *     bundleId: "nano_3_0",
 *     userData: "sudo yum install -y httpd && sudo systemctl start httpd && sudo systemctl enable httpd && echo '<h1>Deployed via Pulumi</h1>' | sudo tee /var/www/html/index.html",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * custom = aws.lightsail.Instance("custom",
 *     name="custom",
 *     availability_zone="us-east-1b",
 *     blueprint_id="amazon_linux_2",
 *     bundle_id="nano_3_0",
 *     user_data="sudo yum install -y httpd && sudo systemctl start httpd && sudo systemctl enable httpd && echo '<h1>Deployed via Pulumi</h1>' | sudo tee /var/www/html/index.html")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var custom = new Aws.LightSail.Instance("custom", new()
 *     {
 *         Name = "custom",
 *         AvailabilityZone = "us-east-1b",
 *         BlueprintId = "amazon_linux_2",
 *         BundleId = "nano_3_0",
 *         UserData = "sudo yum install -y httpd && sudo systemctl start httpd && sudo systemctl enable httpd && echo '<h1>Deployed via Pulumi</h1>' | sudo tee /var/www/html/index.html",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lightsail.NewInstance(ctx, "custom", &lightsail.InstanceArgs{
 * 			Name:             pulumi.String("custom"),
 * 			AvailabilityZone: pulumi.String("us-east-1b"),
 * 			BlueprintId:      pulumi.String("amazon_linux_2"),
 * 			BundleId:         pulumi.String("nano_3_0"),
 * 			UserData:         pulumi.String("sudo yum install -y httpd && sudo systemctl start httpd && sudo systemctl enable httpd && echo '<h1>Deployed via Pulumi</h1>' | sudo tee /var/www/html/index.html"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var custom = new Instance("custom", InstanceArgs.builder()
 *             .name("custom")
 *             .availabilityZone("us-east-1b")
 *             .blueprintId("amazon_linux_2")
 *             .bundleId("nano_3_0")
 *             .userData("sudo yum install -y httpd && sudo systemctl start httpd && sudo systemctl enable httpd && echo '<h1>Deployed via Pulumi</h1>' | sudo tee /var/www/html/index.html")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   custom:
 *     type: aws:lightsail:Instance
 *     properties:
 *       name: custom
 *       availabilityZone: us-east-1b
 *       blueprintId: amazon_linux_2
 *       bundleId: nano_3_0
 *       userData: sudo yum install -y httpd && sudo systemctl start httpd && sudo systemctl enable httpd && echo '<h1>Deployed via Pulumi</h1>' | sudo tee /var/www/html/index.html
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Enable Auto Snapshots
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.lightsail.Instance("test", {
 *     name: "custom_instance",
 *     availabilityZone: "us-east-1b",
 *     blueprintId: "amazon_linux_2",
 *     bundleId: "nano_3_0",
 *     addOn: {
 *         type: "AutoSnapshot",
 *         snapshotTime: "06:00",
 *         status: "Enabled",
 *     },
 *     tags: {
 *         foo: "bar",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.lightsail.Instance("test",
 *     name="custom_instance",
 *     availability_zone="us-east-1b",
 *     blueprint_id="amazon_linux_2",
 *     bundle_id="nano_3_0",
 *     add_on={
 *         "type": "AutoSnapshot",
 *         "snapshot_time": "06:00",
 *         "status": "Enabled",
 *     },
 *     tags={
 *         "foo": "bar",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.LightSail.Instance("test", new()
 *     {
 *         Name = "custom_instance",
 *         AvailabilityZone = "us-east-1b",
 *         BlueprintId = "amazon_linux_2",
 *         BundleId = "nano_3_0",
 *         AddOn = new Aws.LightSail.Inputs.InstanceAddOnArgs
 *         {
 *             Type = "AutoSnapshot",
 *             SnapshotTime = "06:00",
 *             Status = "Enabled",
 *         },
 *         Tags =
 *         {
 *             { "foo", "bar" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lightsail.NewInstance(ctx, "test", &lightsail.InstanceArgs{
 * 			Name:             pulumi.String("custom_instance"),
 * 			AvailabilityZone: pulumi.String("us-east-1b"),
 * 			BlueprintId:      pulumi.String("amazon_linux_2"),
 * 			BundleId:         pulumi.String("nano_3_0"),
 * 			AddOn: &lightsail.InstanceAddOnArgs{
 * 				Type:         pulumi.String("AutoSnapshot"),
 * 				SnapshotTime: pulumi.String("06:00"),
 * 				Status:       pulumi.String("Enabled"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"foo": pulumi.String("bar"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import com.pulumi.aws.lightsail.inputs.InstanceAddOnArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Instance("test", InstanceArgs.builder()
 *             .name("custom_instance")
 *             .availabilityZone("us-east-1b")
 *             .blueprintId("amazon_linux_2")
 *             .bundleId("nano_3_0")
 *             .addOn(InstanceAddOnArgs.builder()
 *                 .type("AutoSnapshot")
 *                 .snapshotTime("06:00")
 *                 .status("Enabled")
 *                 .build())
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:lightsail:Instance
 *     properties:
 *       name: custom_instance
 *       availabilityZone: us-east-1b
 *       blueprintId: amazon_linux_2
 *       bundleId: nano_3_0
 *       addOn:
 *         type: AutoSnapshot
 *         snapshotTime: 06:00
 *         status: Enabled
 *       tags:
 *         foo: bar
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Lightsail Instances using their name. For example:
 * ```sh
 * $ pulumi import aws:lightsail/instance:Instance gitlab_test 'custom_gitlab'
 * ```
 * @property addOn The add on configuration for the instance. Detailed below.
 * @property availabilityZone The Availability Zone in which to create your instance. A
 * list of available zones can be obtained using the AWS CLI command:
 * [`aws lightsail get-regions --include-availability-zones`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-regions.html).
 * @property blueprintId The ID for a virtual private server image. A list of available
 * blueprint IDs can be obtained using the AWS CLI command:
 * [`aws lightsail get-blueprints`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-blueprints.html).
 * @property bundleId The bundle of specification information. A list of available
 * bundle IDs can be obtained using the AWS CLI command:
 * [`aws lightsail get-bundles`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-bundles.html).
 * @property ipAddressType The IP address type of the Lightsail Instance. Valid Values: `dualstack` | `ipv4`.
 * @property keyPairName The name of your key pair. Created in the
 * Lightsail console (cannot use `aws.ec2.KeyPair` at this time)
 * @property name The name of the Lightsail Instance. Names must be unique within each AWS Region in your Lightsail account.
 * @property tags A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property userData Single lined launch script as a string to configure server with additional user data
 */
public data class InstanceArgs(
    public val addOn: Output<InstanceAddOnArgs>? = null,
    public val availabilityZone: Output<String>? = null,
    public val blueprintId: Output<String>? = null,
    public val bundleId: Output<String>? = null,
    public val ipAddressType: Output<String>? = null,
    public val keyPairName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userData: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.InstanceArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.InstanceArgs =
        com.pulumi.aws.lightsail.InstanceArgs.builder()
            .addOn(addOn?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .blueprintId(blueprintId?.applyValue({ args0 -> args0 }))
            .bundleId(bundleId?.applyValue({ args0 -> args0 }))
            .ipAddressType(ipAddressType?.applyValue({ args0 -> args0 }))
            .keyPairName(keyPairName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userData(userData?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var addOn: Output<InstanceAddOnArgs>? = null

    private var availabilityZone: Output<String>? = null

    private var blueprintId: Output<String>? = null

    private var bundleId: Output<String>? = null

    private var ipAddressType: Output<String>? = null

    private var keyPairName: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userData: Output<String>? = null

    /**
     * @param value The add on configuration for the instance. Detailed below.
     */
    @JvmName("xdfjlaogqchmjjti")
    public suspend fun addOn(`value`: Output<InstanceAddOnArgs>) {
        this.addOn = value
    }

    /**
     * @param value The Availability Zone in which to create your instance. A
     * list of available zones can be obtained using the AWS CLI command:
     * [`aws lightsail get-regions --include-availability-zones`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-regions.html).
     */
    @JvmName("gqcjwolrwbitkekx")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value The ID for a virtual private server image. A list of available
     * blueprint IDs can be obtained using the AWS CLI command:
     * [`aws lightsail get-blueprints`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-blueprints.html).
     */
    @JvmName("odbjgwbwolhpoqwo")
    public suspend fun blueprintId(`value`: Output<String>) {
        this.blueprintId = value
    }

    /**
     * @param value The bundle of specification information. A list of available
     * bundle IDs can be obtained using the AWS CLI command:
     * [`aws lightsail get-bundles`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-bundles.html).
     */
    @JvmName("woajusqaqxyawgaa")
    public suspend fun bundleId(`value`: Output<String>) {
        this.bundleId = value
    }

    /**
     * @param value The IP address type of the Lightsail Instance. Valid Values: `dualstack` | `ipv4`.
     */
    @JvmName("rgbvsmcdkdhtnxyb")
    public suspend fun ipAddressType(`value`: Output<String>) {
        this.ipAddressType = value
    }

    /**
     * @param value The name of your key pair. Created in the
     * Lightsail console (cannot use `aws.ec2.KeyPair` at this time)
     */
    @JvmName("thksooujwmjqxpuw")
    public suspend fun keyPairName(`value`: Output<String>) {
        this.keyPairName = value
    }

    /**
     * @param value The name of the Lightsail Instance. Names must be unique within each AWS Region in your Lightsail account.
     */
    @JvmName("kkeldpkoowkhuqat")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bxhhudmubtexumdi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Single lined launch script as a string to configure server with additional user data
     */
    @JvmName("ywrwofhvjnotyimg")
    public suspend fun userData(`value`: Output<String>) {
        this.userData = value
    }

    /**
     * @param value The add on configuration for the instance. Detailed below.
     */
    @JvmName("ywndliujsrimyesu")
    public suspend fun addOn(`value`: InstanceAddOnArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addOn = mapped
    }

    /**
     * @param argument The add on configuration for the instance. Detailed below.
     */
    @JvmName("oimrrakdrfnxqjla")
    public suspend fun addOn(argument: suspend InstanceAddOnArgsBuilder.() -> Unit) {
        val toBeMapped = InstanceAddOnArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.addOn = mapped
    }

    /**
     * @param value The Availability Zone in which to create your instance. A
     * list of available zones can be obtained using the AWS CLI command:
     * [`aws lightsail get-regions --include-availability-zones`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-regions.html).
     */
    @JvmName("wiixeqktrmanvmuj")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value The ID for a virtual private server image. A list of available
     * blueprint IDs can be obtained using the AWS CLI command:
     * [`aws lightsail get-blueprints`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-blueprints.html).
     */
    @JvmName("quhuayifdtgfrrfv")
    public suspend fun blueprintId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blueprintId = mapped
    }

    /**
     * @param value The bundle of specification information. A list of available
     * bundle IDs can be obtained using the AWS CLI command:
     * [`aws lightsail get-bundles`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-bundles.html).
     */
    @JvmName("belpyavvhqaesoic")
    public suspend fun bundleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bundleId = mapped
    }

    /**
     * @param value The IP address type of the Lightsail Instance. Valid Values: `dualstack` | `ipv4`.
     */
    @JvmName("iaxdefkoohchscje")
    public suspend fun ipAddressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddressType = mapped
    }

    /**
     * @param value The name of your key pair. Created in the
     * Lightsail console (cannot use `aws.ec2.KeyPair` at this time)
     */
    @JvmName("xiekudfrqvjehpoo")
    public suspend fun keyPairName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyPairName = mapped
    }

    /**
     * @param value The name of the Lightsail Instance. Names must be unique within each AWS Region in your Lightsail account.
     */
    @JvmName("ssaadqxgddkjnkyd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("phsestmxlugtvrqb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lacfxjmxraxunqmd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Single lined launch script as a string to configure server with additional user data
     */
    @JvmName("pbxsntiosfugxlnv")
    public suspend fun userData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userData = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        addOn = addOn,
        availabilityZone = availabilityZone,
        blueprintId = blueprintId,
        bundleId = bundleId,
        ipAddressType = ipAddressType,
        keyPairName = keyPairName,
        name = name,
        tags = tags,
        userData = userData,
    )
}
