@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.kotlin.outputs.InstancePublicPortsPortInfo
import com.pulumi.aws.lightsail.kotlin.outputs.InstancePublicPortsPortInfo.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [InstancePublicPorts].
 */
@PulumiTagMarker
public class InstancePublicPortsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstancePublicPortsArgs = InstancePublicPortsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstancePublicPortsArgsBuilder.() -> Unit) {
        val builder = InstancePublicPortsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): InstancePublicPorts {
        val builtJavaResource = com.pulumi.aws.lightsail.InstancePublicPorts(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return InstancePublicPorts(builtJavaResource)
    }
}

/**
 * Opens ports for a specific Amazon Lightsail instance, and specifies the IP addresses allowed to connect to the instance through the ports, and the protocol.
 * > See [What is Amazon Lightsail?](https://lightsail.aws.amazon.com/ls/docs/getting-started/article/what-is-amazon-lightsail) for more information.
 * > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail) for more details.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.lightsail.Instance("test", {
 *     name: "yak_sail",
 *     availabilityZone: available.names[0],
 *     blueprintId: "amazon_linux_2",
 *     bundleId: "nano_3_0",
 * });
 * const testInstancePublicPorts = new aws.lightsail.InstancePublicPorts("test", {
 *     instanceName: test.name,
 *     portInfos: [{
 *         protocol: "tcp",
 *         fromPort: 80,
 *         toPort: 80,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.lightsail.Instance("test",
 *     name="yak_sail",
 *     availability_zone=available["names"],
 *     blueprint_id="amazon_linux_2",
 *     bundle_id="nano_3_0")
 * test_instance_public_ports = aws.lightsail.InstancePublicPorts("test",
 *     instance_name=test.name,
 *     port_infos=[{
 *         "protocol": "tcp",
 *         "from_port": 80,
 *         "to_port": 80,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.LightSail.Instance("test", new()
 *     {
 *         Name = "yak_sail",
 *         AvailabilityZone = available.Names[0],
 *         BlueprintId = "amazon_linux_2",
 *         BundleId = "nano_3_0",
 *     });
 *     var testInstancePublicPorts = new Aws.LightSail.InstancePublicPorts("test", new()
 *     {
 *         InstanceName = test.Name,
 *         PortInfos = new[]
 *         {
 *             new Aws.LightSail.Inputs.InstancePublicPortsPortInfoArgs
 *             {
 *                 Protocol = "tcp",
 *                 FromPort = 80,
 *                 ToPort = 80,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := lightsail.NewInstance(ctx, "test", &lightsail.InstanceArgs{
 * 			Name:             pulumi.String("yak_sail"),
 * 			AvailabilityZone: pulumi.Any(available.Names[0]),
 * 			BlueprintId:      pulumi.String("amazon_linux_2"),
 * 			BundleId:         pulumi.String("nano_3_0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lightsail.NewInstancePublicPorts(ctx, "test", &lightsail.InstancePublicPortsArgs{
 * 			InstanceName: test.Name,
 * 			PortInfos: lightsail.InstancePublicPortsPortInfoArray{
 * 				&lightsail.InstancePublicPortsPortInfoArgs{
 * 					Protocol: pulumi.String("tcp"),
 * 					FromPort: pulumi.Int(80),
 * 					ToPort:   pulumi.Int(80),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import com.pulumi.aws.lightsail.InstancePublicPorts;
 * import com.pulumi.aws.lightsail.InstancePublicPortsArgs;
 * import com.pulumi.aws.lightsail.inputs.InstancePublicPortsPortInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Instance("test", InstanceArgs.builder()
 *             .name("yak_sail")
 *             .availabilityZone(available.names()[0])
 *             .blueprintId("amazon_linux_2")
 *             .bundleId("nano_3_0")
 *             .build());
 *         var testInstancePublicPorts = new InstancePublicPorts("testInstancePublicPorts", InstancePublicPortsArgs.builder()
 *             .instanceName(test.name())
 *             .portInfos(InstancePublicPortsPortInfoArgs.builder()
 *                 .protocol("tcp")
 *                 .fromPort(80)
 *                 .toPort(80)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:lightsail:Instance
 *     properties:
 *       name: yak_sail
 *       availabilityZone: ${available.names[0]}
 *       blueprintId: amazon_linux_2
 *       bundleId: nano_3_0
 *   testInstancePublicPorts:
 *     type: aws:lightsail:InstancePublicPorts
 *     name: test
 *     properties:
 *       instanceName: ${test.name}
 *       portInfos:
 *         - protocol: tcp
 *           fromPort: 80
 *           toPort: 80
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class InstancePublicPorts internal constructor(
    override val javaResource: com.pulumi.aws.lightsail.InstancePublicPorts,
) : KotlinCustomResource(javaResource, InstancePublicPortsMapper) {
    /**
     * Name of the Lightsail Instance.
     */
    public val instanceName: Output<String>
        get() = javaResource.instanceName().applyValue({ args0 -> args0 })

    /**
     * Configuration block with port information. AWS closes all currently open ports that are not included in the `port_info`. Detailed below.
     */
    public val portInfos: Output<List<InstancePublicPortsPortInfo>>
        get() = javaResource.portInfos().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })
}

public object InstancePublicPortsMapper : ResourceMapper<InstancePublicPorts> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lightsail.InstancePublicPorts::class == javaResource::class

    override fun map(javaResource: Resource): InstancePublicPorts = InstancePublicPorts(
        javaResource
            as com.pulumi.aws.lightsail.InstancePublicPorts,
    )
}

/**
 * @see [InstancePublicPorts].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InstancePublicPorts].
 */
public suspend fun instancePublicPorts(
    name: String,
    block: suspend InstancePublicPortsResourceBuilder.() -> Unit,
): InstancePublicPorts {
    val builder = InstancePublicPortsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InstancePublicPorts].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instancePublicPorts(name: String): InstancePublicPorts {
    val builder = InstancePublicPortsResourceBuilder()
    builder.name(name)
    return builder.build()
}
