@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.InstancePublicPortsArgs.builder
import com.pulumi.aws.lightsail.kotlin.inputs.InstancePublicPortsPortInfoArgs
import com.pulumi.aws.lightsail.kotlin.inputs.InstancePublicPortsPortInfoArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Opens ports for a specific Amazon Lightsail instance, and specifies the IP addresses allowed to connect to the instance through the ports, and the protocol.
 * > See [What is Amazon Lightsail?](https://lightsail.aws.amazon.com/ls/docs/getting-started/article/what-is-amazon-lightsail) for more information.
 * > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail) for more details.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.lightsail.Instance("test", {
 *     name: "yak_sail",
 *     availabilityZone: available.names[0],
 *     blueprintId: "amazon_linux_2",
 *     bundleId: "nano_3_0",
 * });
 * const testInstancePublicPorts = new aws.lightsail.InstancePublicPorts("test", {
 *     instanceName: test.name,
 *     portInfos: [{
 *         protocol: "tcp",
 *         fromPort: 80,
 *         toPort: 80,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.lightsail.Instance("test",
 *     name="yak_sail",
 *     availability_zone=available["names"],
 *     blueprint_id="amazon_linux_2",
 *     bundle_id="nano_3_0")
 * test_instance_public_ports = aws.lightsail.InstancePublicPorts("test",
 *     instance_name=test.name,
 *     port_infos=[{
 *         "protocol": "tcp",
 *         "from_port": 80,
 *         "to_port": 80,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.LightSail.Instance("test", new()
 *     {
 *         Name = "yak_sail",
 *         AvailabilityZone = available.Names[0],
 *         BlueprintId = "amazon_linux_2",
 *         BundleId = "nano_3_0",
 *     });
 *     var testInstancePublicPorts = new Aws.LightSail.InstancePublicPorts("test", new()
 *     {
 *         InstanceName = test.Name,
 *         PortInfos = new[]
 *         {
 *             new Aws.LightSail.Inputs.InstancePublicPortsPortInfoArgs
 *             {
 *                 Protocol = "tcp",
 *                 FromPort = 80,
 *                 ToPort = 80,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := lightsail.NewInstance(ctx, "test", &lightsail.InstanceArgs{
 * 			Name:             pulumi.String("yak_sail"),
 * 			AvailabilityZone: pulumi.Any(available.Names[0]),
 * 			BlueprintId:      pulumi.String("amazon_linux_2"),
 * 			BundleId:         pulumi.String("nano_3_0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lightsail.NewInstancePublicPorts(ctx, "test", &lightsail.InstancePublicPortsArgs{
 * 			InstanceName: test.Name,
 * 			PortInfos: lightsail.InstancePublicPortsPortInfoArray{
 * 				&lightsail.InstancePublicPortsPortInfoArgs{
 * 					Protocol: pulumi.String("tcp"),
 * 					FromPort: pulumi.Int(80),
 * 					ToPort:   pulumi.Int(80),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import com.pulumi.aws.lightsail.InstancePublicPorts;
 * import com.pulumi.aws.lightsail.InstancePublicPortsArgs;
 * import com.pulumi.aws.lightsail.inputs.InstancePublicPortsPortInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Instance("test", InstanceArgs.builder()
 *             .name("yak_sail")
 *             .availabilityZone(available.names()[0])
 *             .blueprintId("amazon_linux_2")
 *             .bundleId("nano_3_0")
 *             .build());
 *         var testInstancePublicPorts = new InstancePublicPorts("testInstancePublicPorts", InstancePublicPortsArgs.builder()
 *             .instanceName(test.name())
 *             .portInfos(InstancePublicPortsPortInfoArgs.builder()
 *                 .protocol("tcp")
 *                 .fromPort(80)
 *                 .toPort(80)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:lightsail:Instance
 *     properties:
 *       name: yak_sail
 *       availabilityZone: ${available.names[0]}
 *       blueprintId: amazon_linux_2
 *       bundleId: nano_3_0
 *   testInstancePublicPorts:
 *     type: aws:lightsail:InstancePublicPorts
 *     name: test
 *     properties:
 *       instanceName: ${test.name}
 *       portInfos:
 *         - protocol: tcp
 *           fromPort: 80
 *           toPort: 80
 * ```
 * <!--End PulumiCodeChooser -->
 * @property instanceName Name of the Lightsail Instance.
 * @property portInfos Configuration block with port information. AWS closes all currently open ports that are not included in the `port_info`. Detailed below.
 */
public data class InstancePublicPortsArgs(
    public val instanceName: Output<String>? = null,
    public val portInfos: Output<List<InstancePublicPortsPortInfoArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.InstancePublicPortsArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.InstancePublicPortsArgs =
        com.pulumi.aws.lightsail.InstancePublicPortsArgs.builder()
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .portInfos(
                portInfos?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [InstancePublicPortsArgs].
 */
@PulumiTagMarker
public class InstancePublicPortsArgsBuilder internal constructor() {
    private var instanceName: Output<String>? = null

    private var portInfos: Output<List<InstancePublicPortsPortInfoArgs>>? = null

    /**
     * @param value Name of the Lightsail Instance.
     */
    @JvmName("wwnmyinsgwqxgpsb")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value Configuration block with port information. AWS closes all currently open ports that are not included in the `port_info`. Detailed below.
     */
    @JvmName("bxehicrxfowgiucp")
    public suspend fun portInfos(`value`: Output<List<InstancePublicPortsPortInfoArgs>>) {
        this.portInfos = value
    }

    @JvmName("gghfkhmtyccnbifq")
    public suspend fun portInfos(vararg values: Output<InstancePublicPortsPortInfoArgs>) {
        this.portInfos = Output.all(values.asList())
    }

    /**
     * @param values Configuration block with port information. AWS closes all currently open ports that are not included in the `port_info`. Detailed below.
     */
    @JvmName("xeevshqjmvlsmcoh")
    public suspend fun portInfos(values: List<Output<InstancePublicPortsPortInfoArgs>>) {
        this.portInfos = Output.all(values)
    }

    /**
     * @param value Name of the Lightsail Instance.
     */
    @JvmName("falthcvydlnrlmcs")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value Configuration block with port information. AWS closes all currently open ports that are not included in the `port_info`. Detailed below.
     */
    @JvmName("orrjfbgjwgrfxmpl")
    public suspend fun portInfos(`value`: List<InstancePublicPortsPortInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portInfos = mapped
    }

    /**
     * @param argument Configuration block with port information. AWS closes all currently open ports that are not included in the `port_info`. Detailed below.
     */
    @JvmName("lawihvmwdseudeda")
    public suspend fun portInfos(argument: List<suspend InstancePublicPortsPortInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstancePublicPortsPortInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.portInfos = mapped
    }

    /**
     * @param argument Configuration block with port information. AWS closes all currently open ports that are not included in the `port_info`. Detailed below.
     */
    @JvmName("kyalqctbwxknlous")
    public suspend fun portInfos(vararg argument: suspend InstancePublicPortsPortInfoArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InstancePublicPortsPortInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.portInfos = mapped
    }

    /**
     * @param argument Configuration block with port information. AWS closes all currently open ports that are not included in the `port_info`. Detailed below.
     */
    @JvmName("ereibbfsqnjrxnrv")
    public suspend fun portInfos(argument: suspend InstancePublicPortsPortInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InstancePublicPortsPortInfoArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.portInfos = mapped
    }

    /**
     * @param values Configuration block with port information. AWS closes all currently open ports that are not included in the `port_info`. Detailed below.
     */
    @JvmName("viereshbhfrpktlq")
    public suspend fun portInfos(vararg values: InstancePublicPortsPortInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.portInfos = mapped
    }

    internal fun build(): InstancePublicPortsArgs = InstancePublicPortsArgs(
        instanceName = instanceName,
        portInfos = portInfos,
    )
}
