@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.KeyPairArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Lightsail Key Pair, for use with Lightsail Instances. These key pairs
 * are separate from EC2 Key Pairs, and must be created or imported for use with
 * Lightsail.
 * > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail) for more details
 * ## Example Usage
 * ### Create New Key Pair
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * // Create a new Lightsail Key Pair
 * const lgKeyPair = new aws.lightsail.KeyPair("lg_key_pair", {name: "lg_key_pair"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * # Create a new Lightsail Key Pair
 * lg_key_pair = aws.lightsail.KeyPair("lg_key_pair", name="lg_key_pair")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a new Lightsail Key Pair
 *     var lgKeyPair = new Aws.LightSail.KeyPair("lg_key_pair", new()
 *     {
 *         Name = "lg_key_pair",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a new Lightsail Key Pair
 * 		_, err := lightsail.NewKeyPair(ctx, "lg_key_pair", &lightsail.KeyPairArgs{
 * 			Name: pulumi.String("lg_key_pair"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.KeyPair;
 * import com.pulumi.aws.lightsail.KeyPairArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a new Lightsail Key Pair
 *         var lgKeyPair = new KeyPair("lgKeyPair", KeyPairArgs.builder()
 *             .name("lg_key_pair")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a new Lightsail Key Pair
 *   lgKeyPair:
 *     type: aws:lightsail:KeyPair
 *     name: lg_key_pair
 *     properties:
 *       name: lg_key_pair
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Create New Key Pair with PGP Encrypted Private Key
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const lgKeyPair = new aws.lightsail.KeyPair("lg_key_pair", {
 *     name: "lg_key_pair",
 *     pgpKey: "keybase:keybaseusername",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * lg_key_pair = aws.lightsail.KeyPair("lg_key_pair",
 *     name="lg_key_pair",
 *     pgp_key="keybase:keybaseusername")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var lgKeyPair = new Aws.LightSail.KeyPair("lg_key_pair", new()
 *     {
 *         Name = "lg_key_pair",
 *         PgpKey = "keybase:keybaseusername",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lightsail.NewKeyPair(ctx, "lg_key_pair", &lightsail.KeyPairArgs{
 * 			Name:   pulumi.String("lg_key_pair"),
 * 			PgpKey: pulumi.String("keybase:keybaseusername"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.KeyPair;
 * import com.pulumi.aws.lightsail.KeyPairArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lgKeyPair = new KeyPair("lgKeyPair", KeyPairArgs.builder()
 *             .name("lg_key_pair")
 *             .pgpKey("keybase:keybaseusername")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   lgKeyPair:
 *     type: aws:lightsail:KeyPair
 *     name: lg_key_pair
 *     properties:
 *       name: lg_key_pair
 *       pgpKey: keybase:keybaseusername
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Existing Public Key Import
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const lgKeyPair = new aws.lightsail.KeyPair("lg_key_pair", {
 *     name: "importing",
 *     publicKey: std.file({
 *         input: "~/.ssh/id_rsa.pub",
 *     }).then(invoke => invoke.result),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * lg_key_pair = aws.lightsail.KeyPair("lg_key_pair",
 *     name="importing",
 *     public_key=std.file(input="~/.ssh/id_rsa.pub").result)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var lgKeyPair = new Aws.LightSail.KeyPair("lg_key_pair", new()
 *     {
 *         Name = "importing",
 *         PublicKey = Std.File.Invoke(new()
 *         {
 *             Input = "~/.ssh/id_rsa.pub",
 *         }).Apply(invoke => invoke.Result),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "~/.ssh/id_rsa.pub",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lightsail.NewKeyPair(ctx, "lg_key_pair", &lightsail.KeyPairArgs{
 * 			Name:      pulumi.String("importing"),
 * 			PublicKey: pulumi.String(invokeFile.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.KeyPair;
 * import com.pulumi.aws.lightsail.KeyPairArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lgKeyPair = new KeyPair("lgKeyPair", KeyPairArgs.builder()
 *             .name("importing")
 *             .publicKey(StdFunctions.file(FileArgs.builder()
 *                 .input("~/.ssh/id_rsa.pub")
 *                 .build()).result())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   lgKeyPair:
 *     type: aws:lightsail:KeyPair
 *     name: lg_key_pair
 *     properties:
 *       name: importing
 *       publicKey:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: ~/.ssh/id_rsa.pub
 *           Return: result
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You cannot import Lightsail Key Pairs because the private and public key are only available on initial creation.
 * @property name The name of the Lightsail Key Pair. If omitted, a unique name will be generated by this provider
 * @property namePrefix
 * @property pgpKey An optional PGP key to encrypt the resulting private key material. Only used when creating a new key pair
 * @property publicKey The public key material. This public key will be imported into Lightsail
 * @property tags A map of tags to assign to the collection. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * > **NOTE:** a PGP key is not required, however it is strongly encouraged. Without a PGP key, the private key material will be stored in state unencrypted.`pgp_key` is ignored if `public_key` is supplied.
 */
public data class KeyPairArgs(
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val pgpKey: Output<String>? = null,
    public val publicKey: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.KeyPairArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.KeyPairArgs =
        com.pulumi.aws.lightsail.KeyPairArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .pgpKey(pgpKey?.applyValue({ args0 -> args0 }))
            .publicKey(publicKey?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [KeyPairArgs].
 */
@PulumiTagMarker
public class KeyPairArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var pgpKey: Output<String>? = null

    private var publicKey: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the Lightsail Key Pair. If omitted, a unique name will be generated by this provider
     */
    @JvmName("lysrnvdaxhuuxcmv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("vnjqimxgcuukhfoj")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value An optional PGP key to encrypt the resulting private key material. Only used when creating a new key pair
     */
    @JvmName("wilefnfngexokach")
    public suspend fun pgpKey(`value`: Output<String>) {
        this.pgpKey = value
    }

    /**
     * @param value The public key material. This public key will be imported into Lightsail
     */
    @JvmName("ajypyfpufvmiklnl")
    public suspend fun publicKey(`value`: Output<String>) {
        this.publicKey = value
    }

    /**
     * @param value A map of tags to assign to the collection. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * > **NOTE:** a PGP key is not required, however it is strongly encouraged. Without a PGP key, the private key material will be stored in state unencrypted.`pgp_key` is ignored if `public_key` is supplied.
     */
    @JvmName("cgcipkbvlebknagy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the Lightsail Key Pair. If omitted, a unique name will be generated by this provider
     */
    @JvmName("ybcqqutbryfntldx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("tsedhhdqtdhfpnir")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value An optional PGP key to encrypt the resulting private key material. Only used when creating a new key pair
     */
    @JvmName("vpqtbmsobjaojlow")
    public suspend fun pgpKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pgpKey = mapped
    }

    /**
     * @param value The public key material. This public key will be imported into Lightsail
     */
    @JvmName("trrbbyucustrurdf")
    public suspend fun publicKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicKey = mapped
    }

    /**
     * @param value A map of tags to assign to the collection. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * > **NOTE:** a PGP key is not required, however it is strongly encouraged. Without a PGP key, the private key material will be stored in state unencrypted.`pgp_key` is ignored if `public_key` is supplied.
     */
    @JvmName("lceyvajlouferbht")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the collection. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * > **NOTE:** a PGP key is not required, however it is strongly encouraged. Without a PGP key, the private key material will be stored in state unencrypted.`pgp_key` is ignored if `public_key` is supplied.
     */
    @JvmName("cfsrjrsnnvblnlgu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): KeyPairArgs = KeyPairArgs(
        name = name,
        namePrefix = namePrefix,
        pgpKey = pgpKey,
        publicKey = publicKey,
        tags = tags,
    )
}
