@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Lb].
 */
@PulumiTagMarker
public class LbResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LbArgs = LbArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LbArgsBuilder.() -> Unit) {
        val builder = LbArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Lb {
        val builtJavaResource = com.pulumi.aws.lightsail.Lb(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Lb(builtJavaResource)
    }
}

/**
 * Creates a Lightsail load balancer resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.lightsail.Lb("test", {
 *     name: "test-load-balancer",
 *     healthCheckPath: "/",
 *     instancePort: 80,
 *     tags: {
 *         foo: "bar",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.lightsail.Lb("test",
 *     name="test-load-balancer",
 *     health_check_path="/",
 *     instance_port=80,
 *     tags={
 *         "foo": "bar",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.LightSail.Lb("test", new()
 *     {
 *         Name = "test-load-balancer",
 *         HealthCheckPath = "/",
 *         InstancePort = 80,
 *         Tags =
 *         {
 *             { "foo", "bar" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lightsail.NewLb(ctx, "test", &lightsail.LbArgs{
 * 			Name:            pulumi.String("test-load-balancer"),
 * 			HealthCheckPath: pulumi.String("/"),
 * 			InstancePort:    pulumi.Int(80),
 * 			Tags: pulumi.StringMap{
 * 				"foo": pulumi.String("bar"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Lb;
 * import com.pulumi.aws.lightsail.LbArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Lb("test", LbArgs.builder()
 *             .name("test-load-balancer")
 *             .healthCheckPath("/")
 *             .instancePort("80")
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:lightsail:Lb
 *     properties:
 *       name: test-load-balancer
 *       healthCheckPath: /
 *       instancePort: '80'
 *       tags:
 *         foo: bar
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_lb` using the name attribute. For example:
 * ```sh
 * $ pulumi import aws:lightsail/lb:Lb test example-load-balancer
 * ```
 */
public class Lb internal constructor(
    override val javaResource: com.pulumi.aws.lightsail.Lb,
) : KotlinCustomResource(javaResource, LbMapper) {
    /**
     * The ARN of the Lightsail load balancer.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The timestamp when the load balancer was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * The DNS name of the load balancer.
     */
    public val dnsName: Output<String>
        get() = javaResource.dnsName().applyValue({ args0 -> args0 })

    /**
     * The health check path of the load balancer. Default value "/".
     */
    public val healthCheckPath: Output<String>?
        get() = javaResource.healthCheckPath().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The instance port the load balancer will connect.
     */
    public val instancePort: Output<Int>
        get() = javaResource.instancePort().applyValue({ args0 -> args0 })

    public val ipAddressType: Output<String>?
        get() = javaResource.ipAddressType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the Lightsail load balancer.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The protocol of the load balancer.
     */
    public val protocol: Output<String>
        get() = javaResource.protocol().applyValue({ args0 -> args0 })

    /**
     * The public ports of the load balancer.
     */
    public val publicPorts: Output<List<Int>>
        get() = javaResource.publicPorts().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The support code for the database. Include this code in your email to support when you have questions about a database in Lightsail. This code enables our support team to look up your Lightsail information more easily.
     */
    public val supportCode: Output<String>
        get() = javaResource.supportCode().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object LbMapper : ResourceMapper<Lb> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lightsail.Lb::class == javaResource::class

    override fun map(javaResource: Resource): Lb = Lb(javaResource as com.pulumi.aws.lightsail.Lb)
}

/**
 * @see [Lb].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Lb].
 */
public suspend fun lb(name: String, block: suspend LbResourceBuilder.() -> Unit): Lb {
    val builder = LbResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Lb].
 * @param name The _unique_ name of the resulting resource.
 */
public fun lb(name: String): Lb {
    val builder = LbResourceBuilder()
    builder.name(name)
    return builder.build()
}
