@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.kotlin.outputs.LbCertificateDomainValidationRecord
import com.pulumi.aws.lightsail.kotlin.outputs.LbCertificateDomainValidationRecord.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [LbCertificate].
 */
@PulumiTagMarker
public class LbCertificateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LbCertificateArgs = LbCertificateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LbCertificateArgsBuilder.() -> Unit) {
        val builder = LbCertificateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LbCertificate {
        val builtJavaResource = com.pulumi.aws.lightsail.LbCertificate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LbCertificate(builtJavaResource)
    }
}

/**
 * Creates a Lightsail load balancer Certificate resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.lightsail.Lb("test", {
 *     name: "test-load-balancer",
 *     healthCheckPath: "/",
 *     instancePort: 80,
 *     tags: {
 *         foo: "bar",
 *     },
 * });
 * const testLbCertificate = new aws.lightsail.LbCertificate("test", {
 *     name: "test-load-balancer-certificate",
 *     lbName: test.id,
 *     domainName: "test.com",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.lightsail.Lb("test",
 *     name="test-load-balancer",
 *     health_check_path="/",
 *     instance_port=80,
 *     tags={
 *         "foo": "bar",
 *     })
 * test_lb_certificate = aws.lightsail.LbCertificate("test",
 *     name="test-load-balancer-certificate",
 *     lb_name=test.id,
 *     domain_name="test.com")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.LightSail.Lb("test", new()
 *     {
 *         Name = "test-load-balancer",
 *         HealthCheckPath = "/",
 *         InstancePort = 80,
 *         Tags =
 *         {
 *             { "foo", "bar" },
 *         },
 *     });
 *     var testLbCertificate = new Aws.LightSail.LbCertificate("test", new()
 *     {
 *         Name = "test-load-balancer-certificate",
 *         LbName = test.Id,
 *         DomainName = "test.com",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := lightsail.NewLb(ctx, "test", &lightsail.LbArgs{
 * 			Name:            pulumi.String("test-load-balancer"),
 * 			HealthCheckPath: pulumi.String("/"),
 * 			InstancePort:    pulumi.Int(80),
 * 			Tags: pulumi.StringMap{
 * 				"foo": pulumi.String("bar"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lightsail.NewLbCertificate(ctx, "test", &lightsail.LbCertificateArgs{
 * 			Name:       pulumi.String("test-load-balancer-certificate"),
 * 			LbName:     test.ID(),
 * 			DomainName: pulumi.String("test.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Lb;
 * import com.pulumi.aws.lightsail.LbArgs;
 * import com.pulumi.aws.lightsail.LbCertificate;
 * import com.pulumi.aws.lightsail.LbCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Lb("test", LbArgs.builder()
 *             .name("test-load-balancer")
 *             .healthCheckPath("/")
 *             .instancePort("80")
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *         var testLbCertificate = new LbCertificate("testLbCertificate", LbCertificateArgs.builder()
 *             .name("test-load-balancer-certificate")
 *             .lbName(test.id())
 *             .domainName("test.com")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:lightsail:Lb
 *     properties:
 *       name: test-load-balancer
 *       healthCheckPath: /
 *       instancePort: '80'
 *       tags:
 *         foo: bar
 *   testLbCertificate:
 *     type: aws:lightsail:LbCertificate
 *     name: test
 *     properties:
 *       name: test-load-balancer-certificate
 *       lbName: ${test.id}
 *       domainName: test.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_lb_certificate` using the id attribute. For example:
 * ```sh
 * $ pulumi import aws:lightsail/lbCertificate:LbCertificate test example-load-balancer,example-load-balancer-certificate
 * ```
 */
public class LbCertificate internal constructor(
    override val javaResource: com.pulumi.aws.lightsail.LbCertificate,
) : KotlinCustomResource(javaResource, LbCertificateMapper) {
    /**
     * The ARN of the lightsail certificate.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The timestamp when the instance was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * The domain name (e.g., example.com) for your SSL/TLS certificate.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    public val domainValidationRecords: Output<List<LbCertificateDomainValidationRecord>>
        get() = javaResource.domainValidationRecords().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * The load balancer name where you want to create the SSL/TLS certificate.
     */
    public val lbName: Output<String>
        get() = javaResource.lbName().applyValue({ args0 -> args0 })

    /**
     * The SSL/TLS certificate name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Set of domains that should be SANs in the issued certificate. `domain_name` attribute is automatically added as a Subject Alternative Name.
     */
    public val subjectAlternativeNames: Output<List<String>>
        get() = javaResource.subjectAlternativeNames().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    public val supportCode: Output<String>
        get() = javaResource.supportCode().applyValue({ args0 -> args0 })
}

public object LbCertificateMapper : ResourceMapper<LbCertificate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lightsail.LbCertificate::class == javaResource::class

    override fun map(javaResource: Resource): LbCertificate = LbCertificate(
        javaResource as
            com.pulumi.aws.lightsail.LbCertificate,
    )
}

/**
 * @see [LbCertificate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LbCertificate].
 */
public suspend fun lbCertificate(
    name: String,
    block: suspend LbCertificateResourceBuilder.() -> Unit,
): LbCertificate {
    val builder = LbCertificateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LbCertificate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun lbCertificate(name: String): LbCertificate {
    val builder = LbCertificateResourceBuilder()
    builder.name(name)
    return builder.build()
}
