@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.LbCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Creates a Lightsail load balancer Certificate resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.lightsail.Lb("test", {
 *     name: "test-load-balancer",
 *     healthCheckPath: "/",
 *     instancePort: 80,
 *     tags: {
 *         foo: "bar",
 *     },
 * });
 * const testLbCertificate = new aws.lightsail.LbCertificate("test", {
 *     name: "test-load-balancer-certificate",
 *     lbName: test.id,
 *     domainName: "test.com",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.lightsail.Lb("test",
 *     name="test-load-balancer",
 *     health_check_path="/",
 *     instance_port=80,
 *     tags={
 *         "foo": "bar",
 *     })
 * test_lb_certificate = aws.lightsail.LbCertificate("test",
 *     name="test-load-balancer-certificate",
 *     lb_name=test.id,
 *     domain_name="test.com")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.LightSail.Lb("test", new()
 *     {
 *         Name = "test-load-balancer",
 *         HealthCheckPath = "/",
 *         InstancePort = 80,
 *         Tags =
 *         {
 *             { "foo", "bar" },
 *         },
 *     });
 *     var testLbCertificate = new Aws.LightSail.LbCertificate("test", new()
 *     {
 *         Name = "test-load-balancer-certificate",
 *         LbName = test.Id,
 *         DomainName = "test.com",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := lightsail.NewLb(ctx, "test", &lightsail.LbArgs{
 * 			Name:            pulumi.String("test-load-balancer"),
 * 			HealthCheckPath: pulumi.String("/"),
 * 			InstancePort:    pulumi.Int(80),
 * 			Tags: pulumi.StringMap{
 * 				"foo": pulumi.String("bar"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lightsail.NewLbCertificate(ctx, "test", &lightsail.LbCertificateArgs{
 * 			Name:       pulumi.String("test-load-balancer-certificate"),
 * 			LbName:     test.ID(),
 * 			DomainName: pulumi.String("test.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Lb;
 * import com.pulumi.aws.lightsail.LbArgs;
 * import com.pulumi.aws.lightsail.LbCertificate;
 * import com.pulumi.aws.lightsail.LbCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Lb("test", LbArgs.builder()
 *             .name("test-load-balancer")
 *             .healthCheckPath("/")
 *             .instancePort("80")
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *         var testLbCertificate = new LbCertificate("testLbCertificate", LbCertificateArgs.builder()
 *             .name("test-load-balancer-certificate")
 *             .lbName(test.id())
 *             .domainName("test.com")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:lightsail:Lb
 *     properties:
 *       name: test-load-balancer
 *       healthCheckPath: /
 *       instancePort: '80'
 *       tags:
 *         foo: bar
 *   testLbCertificate:
 *     type: aws:lightsail:LbCertificate
 *     name: test
 *     properties:
 *       name: test-load-balancer-certificate
 *       lbName: ${test.id}
 *       domainName: test.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_lb_certificate` using the id attribute. For example:
 * ```sh
 * $ pulumi import aws:lightsail/lbCertificate:LbCertificate test example-load-balancer,example-load-balancer-certificate
 * ```
 * @property domainName The domain name (e.g., example.com) for your SSL/TLS certificate.
 * @property lbName The load balancer name where you want to create the SSL/TLS certificate.
 * @property name The SSL/TLS certificate name.
 * @property subjectAlternativeNames Set of domains that should be SANs in the issued certificate. `domain_name` attribute is automatically added as a Subject Alternative Name.
 */
public data class LbCertificateArgs(
    public val domainName: Output<String>? = null,
    public val lbName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val subjectAlternativeNames: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.LbCertificateArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.LbCertificateArgs =
        com.pulumi.aws.lightsail.LbCertificateArgs.builder()
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .lbName(lbName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .subjectAlternativeNames(
                subjectAlternativeNames?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [LbCertificateArgs].
 */
@PulumiTagMarker
public class LbCertificateArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    private var lbName: Output<String>? = null

    private var name: Output<String>? = null

    private var subjectAlternativeNames: Output<List<String>>? = null

    /**
     * @param value The domain name (e.g., example.com) for your SSL/TLS certificate.
     */
    @JvmName("yvhawlcbdqkxnijw")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The load balancer name where you want to create the SSL/TLS certificate.
     */
    @JvmName("ceycgdtpbgsipood")
    public suspend fun lbName(`value`: Output<String>) {
        this.lbName = value
    }

    /**
     * @param value The SSL/TLS certificate name.
     */
    @JvmName("pbjceuwxdpvwetlf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Set of domains that should be SANs in the issued certificate. `domain_name` attribute is automatically added as a Subject Alternative Name.
     */
    @JvmName("nwcowalglnpbajrb")
    public suspend fun subjectAlternativeNames(`value`: Output<List<String>>) {
        this.subjectAlternativeNames = value
    }

    @JvmName("khfqtgoleihyspwq")
    public suspend fun subjectAlternativeNames(vararg values: Output<String>) {
        this.subjectAlternativeNames = Output.all(values.asList())
    }

    /**
     * @param values Set of domains that should be SANs in the issued certificate. `domain_name` attribute is automatically added as a Subject Alternative Name.
     */
    @JvmName("wclwayggxfhhybgv")
    public suspend fun subjectAlternativeNames(values: List<Output<String>>) {
        this.subjectAlternativeNames = Output.all(values)
    }

    /**
     * @param value The domain name (e.g., example.com) for your SSL/TLS certificate.
     */
    @JvmName("iyttuhapnjnilamr")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The load balancer name where you want to create the SSL/TLS certificate.
     */
    @JvmName("nwnbjahafgodnjgb")
    public suspend fun lbName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lbName = mapped
    }

    /**
     * @param value The SSL/TLS certificate name.
     */
    @JvmName("mgajttldyibmfwjd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Set of domains that should be SANs in the issued certificate. `domain_name` attribute is automatically added as a Subject Alternative Name.
     */
    @JvmName("jlliqttpcjnheqon")
    public suspend fun subjectAlternativeNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subjectAlternativeNames = mapped
    }

    /**
     * @param values Set of domains that should be SANs in the issued certificate. `domain_name` attribute is automatically added as a Subject Alternative Name.
     */
    @JvmName("wmnxcbroqxxenkxt")
    public suspend fun subjectAlternativeNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subjectAlternativeNames = mapped
    }

    internal fun build(): LbCertificateArgs = LbCertificateArgs(
        domainName = domainName,
        lbName = lbName,
        name = name,
        subjectAlternativeNames = subjectAlternativeNames,
    )
}
