@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.LbCertificateAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Attaches a Lightsail Load Balancer Certificate to a Lightsail Load Balancer.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.lightsail.Lb("test", {
 *     name: "test-load-balancer",
 *     healthCheckPath: "/",
 *     instancePort: 80,
 *     tags: {
 *         foo: "bar",
 *     },
 * });
 * const testLbCertificate = new aws.lightsail.LbCertificate("test", {
 *     name: "test-load-balancer-certificate",
 *     lbName: test.id,
 *     domainName: "test.com",
 * });
 * const testLbCertificateAttachment = new aws.lightsail.LbCertificateAttachment("test", {
 *     lbName: test.name,
 *     certificateName: testLbCertificate.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.lightsail.Lb("test",
 *     name="test-load-balancer",
 *     health_check_path="/",
 *     instance_port=80,
 *     tags={
 *         "foo": "bar",
 *     })
 * test_lb_certificate = aws.lightsail.LbCertificate("test",
 *     name="test-load-balancer-certificate",
 *     lb_name=test.id,
 *     domain_name="test.com")
 * test_lb_certificate_attachment = aws.lightsail.LbCertificateAttachment("test",
 *     lb_name=test.name,
 *     certificate_name=test_lb_certificate.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.LightSail.Lb("test", new()
 *     {
 *         Name = "test-load-balancer",
 *         HealthCheckPath = "/",
 *         InstancePort = 80,
 *         Tags =
 *         {
 *             { "foo", "bar" },
 *         },
 *     });
 *     var testLbCertificate = new Aws.LightSail.LbCertificate("test", new()
 *     {
 *         Name = "test-load-balancer-certificate",
 *         LbName = test.Id,
 *         DomainName = "test.com",
 *     });
 *     var testLbCertificateAttachment = new Aws.LightSail.LbCertificateAttachment("test", new()
 *     {
 *         LbName = test.Name,
 *         CertificateName = testLbCertificate.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := lightsail.NewLb(ctx, "test", &lightsail.LbArgs{
 * 			Name:            pulumi.String("test-load-balancer"),
 * 			HealthCheckPath: pulumi.String("/"),
 * 			InstancePort:    pulumi.Int(80),
 * 			Tags: pulumi.StringMap{
 * 				"foo": pulumi.String("bar"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testLbCertificate, err := lightsail.NewLbCertificate(ctx, "test", &lightsail.LbCertificateArgs{
 * 			Name:       pulumi.String("test-load-balancer-certificate"),
 * 			LbName:     test.ID(),
 * 			DomainName: pulumi.String("test.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lightsail.NewLbCertificateAttachment(ctx, "test", &lightsail.LbCertificateAttachmentArgs{
 * 			LbName:          test.Name,
 * 			CertificateName: testLbCertificate.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Lb;
 * import com.pulumi.aws.lightsail.LbArgs;
 * import com.pulumi.aws.lightsail.LbCertificate;
 * import com.pulumi.aws.lightsail.LbCertificateArgs;
 * import com.pulumi.aws.lightsail.LbCertificateAttachment;
 * import com.pulumi.aws.lightsail.LbCertificateAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Lb("test", LbArgs.builder()
 *             .name("test-load-balancer")
 *             .healthCheckPath("/")
 *             .instancePort("80")
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *         var testLbCertificate = new LbCertificate("testLbCertificate", LbCertificateArgs.builder()
 *             .name("test-load-balancer-certificate")
 *             .lbName(test.id())
 *             .domainName("test.com")
 *             .build());
 *         var testLbCertificateAttachment = new LbCertificateAttachment("testLbCertificateAttachment", LbCertificateAttachmentArgs.builder()
 *             .lbName(test.name())
 *             .certificateName(testLbCertificate.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:lightsail:Lb
 *     properties:
 *       name: test-load-balancer
 *       healthCheckPath: /
 *       instancePort: '80'
 *       tags:
 *         foo: bar
 *   testLbCertificate:
 *     type: aws:lightsail:LbCertificate
 *     name: test
 *     properties:
 *       name: test-load-balancer-certificate
 *       lbName: ${test.id}
 *       domainName: test.com
 *   testLbCertificateAttachment:
 *     type: aws:lightsail:LbCertificateAttachment
 *     name: test
 *     properties:
 *       lbName: ${test.name}
 *       certificateName: ${testLbCertificate.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_lb_certificate_attachment` using the name attribute. For example:
 * ```sh
 * $ pulumi import aws:lightsail/lbCertificateAttachment:LbCertificateAttachment test example-load-balancer,example-certificate
 * ```
 * @property certificateName The name of your SSL/TLS certificate.
 * @property lbName The name of the load balancer to which you want to associate the SSL/TLS certificate.
 */
public data class LbCertificateAttachmentArgs(
    public val certificateName: Output<String>? = null,
    public val lbName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.LbCertificateAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.LbCertificateAttachmentArgs =
        com.pulumi.aws.lightsail.LbCertificateAttachmentArgs.builder()
            .certificateName(certificateName?.applyValue({ args0 -> args0 }))
            .lbName(lbName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LbCertificateAttachmentArgs].
 */
@PulumiTagMarker
public class LbCertificateAttachmentArgsBuilder internal constructor() {
    private var certificateName: Output<String>? = null

    private var lbName: Output<String>? = null

    /**
     * @param value The name of your SSL/TLS certificate.
     */
    @JvmName("disbcaxlncajpprv")
    public suspend fun certificateName(`value`: Output<String>) {
        this.certificateName = value
    }

    /**
     * @param value The name of the load balancer to which you want to associate the SSL/TLS certificate.
     */
    @JvmName("ktxwinlcsrvesuiq")
    public suspend fun lbName(`value`: Output<String>) {
        this.lbName = value
    }

    /**
     * @param value The name of your SSL/TLS certificate.
     */
    @JvmName("uwcpkjkvennfdtvx")
    public suspend fun certificateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateName = mapped
    }

    /**
     * @param value The name of the load balancer to which you want to associate the SSL/TLS certificate.
     */
    @JvmName("pvydppbrqhcyhdas")
    public suspend fun lbName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lbName = mapped
    }

    internal fun build(): LbCertificateAttachmentArgs = LbCertificateAttachmentArgs(
        certificateName = certificateName,
        lbName = lbName,
    )
}
