@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LbStickinessPolicy].
 */
@PulumiTagMarker
public class LbStickinessPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LbStickinessPolicyArgs = LbStickinessPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LbStickinessPolicyArgsBuilder.() -> Unit) {
        val builder = LbStickinessPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LbStickinessPolicy {
        val builtJavaResource = com.pulumi.aws.lightsail.LbStickinessPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LbStickinessPolicy(builtJavaResource)
    }
}

/**
 * Configures Session Stickiness for a Lightsail Load Balancer.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.lightsail.Lb("test", {
 *     name: "test-load-balancer",
 *     healthCheckPath: "/",
 *     instancePort: 80,
 *     tags: {
 *         foo: "bar",
 *     },
 * });
 * const testLbStickinessPolicy = new aws.lightsail.LbStickinessPolicy("test", {
 *     lbName: test.name,
 *     cookieDuration: 900,
 *     enabled: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.lightsail.Lb("test",
 *     name="test-load-balancer",
 *     health_check_path="/",
 *     instance_port=80,
 *     tags={
 *         "foo": "bar",
 *     })
 * test_lb_stickiness_policy = aws.lightsail.LbStickinessPolicy("test",
 *     lb_name=test.name,
 *     cookie_duration=900,
 *     enabled=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.LightSail.Lb("test", new()
 *     {
 *         Name = "test-load-balancer",
 *         HealthCheckPath = "/",
 *         InstancePort = 80,
 *         Tags =
 *         {
 *             { "foo", "bar" },
 *         },
 *     });
 *     var testLbStickinessPolicy = new Aws.LightSail.LbStickinessPolicy("test", new()
 *     {
 *         LbName = test.Name,
 *         CookieDuration = 900,
 *         Enabled = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := lightsail.NewLb(ctx, "test", &lightsail.LbArgs{
 * 			Name:            pulumi.String("test-load-balancer"),
 * 			HealthCheckPath: pulumi.String("/"),
 * 			InstancePort:    pulumi.Int(80),
 * 			Tags: pulumi.StringMap{
 * 				"foo": pulumi.String("bar"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lightsail.NewLbStickinessPolicy(ctx, "test", &lightsail.LbStickinessPolicyArgs{
 * 			LbName:         test.Name,
 * 			CookieDuration: pulumi.Int(900),
 * 			Enabled:        pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Lb;
 * import com.pulumi.aws.lightsail.LbArgs;
 * import com.pulumi.aws.lightsail.LbStickinessPolicy;
 * import com.pulumi.aws.lightsail.LbStickinessPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Lb("test", LbArgs.builder()
 *             .name("test-load-balancer")
 *             .healthCheckPath("/")
 *             .instancePort("80")
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *         var testLbStickinessPolicy = new LbStickinessPolicy("testLbStickinessPolicy", LbStickinessPolicyArgs.builder()
 *             .lbName(test.name())
 *             .cookieDuration(900)
 *             .enabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:lightsail:Lb
 *     properties:
 *       name: test-load-balancer
 *       healthCheckPath: /
 *       instancePort: '80'
 *       tags:
 *         foo: bar
 *   testLbStickinessPolicy:
 *     type: aws:lightsail:LbStickinessPolicy
 *     name: test
 *     properties:
 *       lbName: ${test.name}
 *       cookieDuration: 900
 *       enabled: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_lb_stickiness_policy` using the `lb_name` attribute. For example:
 * ```sh
 * $ pulumi import aws:lightsail/lbStickinessPolicy:LbStickinessPolicy test example-load-balancer
 * ```
 */
public class LbStickinessPolicy internal constructor(
    override val javaResource: com.pulumi.aws.lightsail.LbStickinessPolicy,
) : KotlinCustomResource(javaResource, LbStickinessPolicyMapper) {
    /**
     * The cookie duration in seconds. This determines the length of the session stickiness.
     */
    public val cookieDuration: Output<Int>
        get() = javaResource.cookieDuration().applyValue({ args0 -> args0 })

    /**
     * The Session Stickiness state of the load balancer. `true` to activate session stickiness or `false` to deactivate session stickiness.
     */
    public val enabled: Output<Boolean>
        get() = javaResource.enabled().applyValue({ args0 -> args0 })

    /**
     * The name of the load balancer to which you want to enable session stickiness.
     */
    public val lbName: Output<String>
        get() = javaResource.lbName().applyValue({ args0 -> args0 })
}

public object LbStickinessPolicyMapper : ResourceMapper<LbStickinessPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lightsail.LbStickinessPolicy::class == javaResource::class

    override fun map(javaResource: Resource): LbStickinessPolicy = LbStickinessPolicy(
        javaResource as
            com.pulumi.aws.lightsail.LbStickinessPolicy,
    )
}

/**
 * @see [LbStickinessPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LbStickinessPolicy].
 */
public suspend fun lbStickinessPolicy(
    name: String,
    block: suspend LbStickinessPolicyResourceBuilder.() -> Unit,
): LbStickinessPolicy {
    val builder = LbStickinessPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LbStickinessPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun lbStickinessPolicy(name: String): LbStickinessPolicy {
    val builder = LbStickinessPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
