@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.LbStickinessPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Configures Session Stickiness for a Lightsail Load Balancer.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.lightsail.Lb("test", {
 *     name: "test-load-balancer",
 *     healthCheckPath: "/",
 *     instancePort: 80,
 *     tags: {
 *         foo: "bar",
 *     },
 * });
 * const testLbStickinessPolicy = new aws.lightsail.LbStickinessPolicy("test", {
 *     lbName: test.name,
 *     cookieDuration: 900,
 *     enabled: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.lightsail.Lb("test",
 *     name="test-load-balancer",
 *     health_check_path="/",
 *     instance_port=80,
 *     tags={
 *         "foo": "bar",
 *     })
 * test_lb_stickiness_policy = aws.lightsail.LbStickinessPolicy("test",
 *     lb_name=test.name,
 *     cookie_duration=900,
 *     enabled=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.LightSail.Lb("test", new()
 *     {
 *         Name = "test-load-balancer",
 *         HealthCheckPath = "/",
 *         InstancePort = 80,
 *         Tags =
 *         {
 *             { "foo", "bar" },
 *         },
 *     });
 *     var testLbStickinessPolicy = new Aws.LightSail.LbStickinessPolicy("test", new()
 *     {
 *         LbName = test.Name,
 *         CookieDuration = 900,
 *         Enabled = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := lightsail.NewLb(ctx, "test", &lightsail.LbArgs{
 * 			Name:            pulumi.String("test-load-balancer"),
 * 			HealthCheckPath: pulumi.String("/"),
 * 			InstancePort:    pulumi.Int(80),
 * 			Tags: pulumi.StringMap{
 * 				"foo": pulumi.String("bar"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lightsail.NewLbStickinessPolicy(ctx, "test", &lightsail.LbStickinessPolicyArgs{
 * 			LbName:         test.Name,
 * 			CookieDuration: pulumi.Int(900),
 * 			Enabled:        pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Lb;
 * import com.pulumi.aws.lightsail.LbArgs;
 * import com.pulumi.aws.lightsail.LbStickinessPolicy;
 * import com.pulumi.aws.lightsail.LbStickinessPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Lb("test", LbArgs.builder()
 *             .name("test-load-balancer")
 *             .healthCheckPath("/")
 *             .instancePort("80")
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *         var testLbStickinessPolicy = new LbStickinessPolicy("testLbStickinessPolicy", LbStickinessPolicyArgs.builder()
 *             .lbName(test.name())
 *             .cookieDuration(900)
 *             .enabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:lightsail:Lb
 *     properties:
 *       name: test-load-balancer
 *       healthCheckPath: /
 *       instancePort: '80'
 *       tags:
 *         foo: bar
 *   testLbStickinessPolicy:
 *     type: aws:lightsail:LbStickinessPolicy
 *     name: test
 *     properties:
 *       lbName: ${test.name}
 *       cookieDuration: 900
 *       enabled: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_lb_stickiness_policy` using the `lb_name` attribute. For example:
 * ```sh
 * $ pulumi import aws:lightsail/lbStickinessPolicy:LbStickinessPolicy test example-load-balancer
 * ```
 * @property cookieDuration The cookie duration in seconds. This determines the length of the session stickiness.
 * @property enabled The Session Stickiness state of the load balancer. `true` to activate session stickiness or `false` to deactivate session stickiness.
 * @property lbName The name of the load balancer to which you want to enable session stickiness.
 */
public data class LbStickinessPolicyArgs(
    public val cookieDuration: Output<Int>? = null,
    public val enabled: Output<Boolean>? = null,
    public val lbName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.LbStickinessPolicyArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.LbStickinessPolicyArgs =
        com.pulumi.aws.lightsail.LbStickinessPolicyArgs.builder()
            .cookieDuration(cookieDuration?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .lbName(lbName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LbStickinessPolicyArgs].
 */
@PulumiTagMarker
public class LbStickinessPolicyArgsBuilder internal constructor() {
    private var cookieDuration: Output<Int>? = null

    private var enabled: Output<Boolean>? = null

    private var lbName: Output<String>? = null

    /**
     * @param value The cookie duration in seconds. This determines the length of the session stickiness.
     */
    @JvmName("mvtihcifxwpmuoch")
    public suspend fun cookieDuration(`value`: Output<Int>) {
        this.cookieDuration = value
    }

    /**
     * @param value The Session Stickiness state of the load balancer. `true` to activate session stickiness or `false` to deactivate session stickiness.
     */
    @JvmName("msvjhmdcjwvjaplq")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The name of the load balancer to which you want to enable session stickiness.
     */
    @JvmName("swaidfaxlrppmhil")
    public suspend fun lbName(`value`: Output<String>) {
        this.lbName = value
    }

    /**
     * @param value The cookie duration in seconds. This determines the length of the session stickiness.
     */
    @JvmName("fjndhimlcrmogofx")
    public suspend fun cookieDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookieDuration = mapped
    }

    /**
     * @param value The Session Stickiness state of the load balancer. `true` to activate session stickiness or `false` to deactivate session stickiness.
     */
    @JvmName("xnekudlopcthgcjf")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The name of the load balancer to which you want to enable session stickiness.
     */
    @JvmName("gcwtnvelmltmepuw")
    public suspend fun lbName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lbName = mapped
    }

    internal fun build(): LbStickinessPolicyArgs = LbStickinessPolicyArgs(
        cookieDuration = cookieDuration,
        enabled = enabled,
        lbName = lbName,
    )
}
