@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [StaticIp].
 */
@PulumiTagMarker
public class StaticIpResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StaticIpArgs = StaticIpArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StaticIpArgsBuilder.() -> Unit) {
        val builder = StaticIpArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): StaticIp {
        val builtJavaResource = com.pulumi.aws.lightsail.StaticIp(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return StaticIp(builtJavaResource)
    }
}

/**
 * Allocates a static IP address.
 * > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail) for more details
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.lightsail.StaticIp("test", {name: "example"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.lightsail.StaticIp("test", name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.LightSail.StaticIp("test", new()
 *     {
 *         Name = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lightsail.NewStaticIp(ctx, "test", &lightsail.StaticIpArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.StaticIp;
 * import com.pulumi.aws.lightsail.StaticIpArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new StaticIp("test", StaticIpArgs.builder()
 *             .name("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:lightsail:StaticIp
 *     properties:
 *       name: example
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class StaticIp internal constructor(
    override val javaResource: com.pulumi.aws.lightsail.StaticIp,
) : KotlinCustomResource(javaResource, StaticIpMapper) {
    /**
     * The ARN of the Lightsail static IP
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The allocated static IP address
     */
    public val ipAddress: Output<String>
        get() = javaResource.ipAddress().applyValue({ args0 -> args0 })

    /**
     * The name for the allocated static IP
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The support code.
     */
    public val supportCode: Output<String>
        get() = javaResource.supportCode().applyValue({ args0 -> args0 })
}

public object StaticIpMapper : ResourceMapper<StaticIp> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lightsail.StaticIp::class == javaResource::class

    override fun map(javaResource: Resource): StaticIp = StaticIp(
        javaResource as
            com.pulumi.aws.lightsail.StaticIp,
    )
}

/**
 * @see [StaticIp].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StaticIp].
 */
public suspend fun staticIp(name: String, block: suspend StaticIpResourceBuilder.() -> Unit): StaticIp {
    val builder = StaticIpResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StaticIp].
 * @param name The _unique_ name of the resulting resource.
 */
public fun staticIp(name: String): StaticIp {
    val builder = StaticIpResourceBuilder()
    builder.name(name)
    return builder.build()
}
