@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [StaticIpAttachment].
 */
@PulumiTagMarker
public class StaticIpAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StaticIpAttachmentArgs = StaticIpAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StaticIpAttachmentArgsBuilder.() -> Unit) {
        val builder = StaticIpAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): StaticIpAttachment {
        val builtJavaResource = com.pulumi.aws.lightsail.StaticIpAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return StaticIpAttachment(builtJavaResource)
    }
}

/**
 * Provides a static IP address attachment - relationship between a Lightsail static IP & Lightsail instance.
 * > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail) for more details
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testStaticIp = new aws.lightsail.StaticIp("test", {name: "example"});
 * const testInstance = new aws.lightsail.Instance("test", {
 *     name: "example",
 *     availabilityZone: "us-east-1b",
 *     blueprintId: "string",
 *     bundleId: "string",
 *     keyPairName: "some_key_name",
 * });
 * const test = new aws.lightsail.StaticIpAttachment("test", {
 *     staticIpName: testStaticIp.id,
 *     instanceName: testInstance.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_static_ip = aws.lightsail.StaticIp("test", name="example")
 * test_instance = aws.lightsail.Instance("test",
 *     name="example",
 *     availability_zone="us-east-1b",
 *     blueprint_id="string",
 *     bundle_id="string",
 *     key_pair_name="some_key_name")
 * test = aws.lightsail.StaticIpAttachment("test",
 *     static_ip_name=test_static_ip.id,
 *     instance_name=test_instance.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testStaticIp = new Aws.LightSail.StaticIp("test", new()
 *     {
 *         Name = "example",
 *     });
 *     var testInstance = new Aws.LightSail.Instance("test", new()
 *     {
 *         Name = "example",
 *         AvailabilityZone = "us-east-1b",
 *         BlueprintId = "string",
 *         BundleId = "string",
 *         KeyPairName = "some_key_name",
 *     });
 *     var test = new Aws.LightSail.StaticIpAttachment("test", new()
 *     {
 *         StaticIpName = testStaticIp.Id,
 *         InstanceName = testInstance.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		testStaticIp, err := lightsail.NewStaticIp(ctx, "test", &lightsail.StaticIpArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testInstance, err := lightsail.NewInstance(ctx, "test", &lightsail.InstanceArgs{
 * 			Name:             pulumi.String("example"),
 * 			AvailabilityZone: pulumi.String("us-east-1b"),
 * 			BlueprintId:      pulumi.String("string"),
 * 			BundleId:         pulumi.String("string"),
 * 			KeyPairName:      pulumi.String("some_key_name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lightsail.NewStaticIpAttachment(ctx, "test", &lightsail.StaticIpAttachmentArgs{
 * 			StaticIpName: testStaticIp.ID(),
 * 			InstanceName: testInstance.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.StaticIp;
 * import com.pulumi.aws.lightsail.StaticIpArgs;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import com.pulumi.aws.lightsail.StaticIpAttachment;
 * import com.pulumi.aws.lightsail.StaticIpAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testStaticIp = new StaticIp("testStaticIp", StaticIpArgs.builder()
 *             .name("example")
 *             .build());
 *         var testInstance = new Instance("testInstance", InstanceArgs.builder()
 *             .name("example")
 *             .availabilityZone("us-east-1b")
 *             .blueprintId("string")
 *             .bundleId("string")
 *             .keyPairName("some_key_name")
 *             .build());
 *         var test = new StaticIpAttachment("test", StaticIpAttachmentArgs.builder()
 *             .staticIpName(testStaticIp.id())
 *             .instanceName(testInstance.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:lightsail:StaticIpAttachment
 *     properties:
 *       staticIpName: ${testStaticIp.id}
 *       instanceName: ${testInstance.id}
 *   testStaticIp:
 *     type: aws:lightsail:StaticIp
 *     name: test
 *     properties:
 *       name: example
 *   testInstance:
 *     type: aws:lightsail:Instance
 *     name: test
 *     properties:
 *       name: example
 *       availabilityZone: us-east-1b
 *       blueprintId: string
 *       bundleId: string
 *       keyPairName: some_key_name
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class StaticIpAttachment internal constructor(
    override val javaResource: com.pulumi.aws.lightsail.StaticIpAttachment,
) : KotlinCustomResource(javaResource, StaticIpAttachmentMapper) {
    /**
     * The name of the Lightsail instance to attach the IP to
     */
    public val instanceName: Output<String>
        get() = javaResource.instanceName().applyValue({ args0 -> args0 })

    /**
     * The allocated static IP address
     */
    public val ipAddress: Output<String>
        get() = javaResource.ipAddress().applyValue({ args0 -> args0 })

    /**
     * The name of the allocated static IP
     */
    public val staticIpName: Output<String>
        get() = javaResource.staticIpName().applyValue({ args0 -> args0 })
}

public object StaticIpAttachmentMapper : ResourceMapper<StaticIpAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lightsail.StaticIpAttachment::class == javaResource::class

    override fun map(javaResource: Resource): StaticIpAttachment = StaticIpAttachment(
        javaResource as
            com.pulumi.aws.lightsail.StaticIpAttachment,
    )
}

/**
 * @see [StaticIpAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StaticIpAttachment].
 */
public suspend fun staticIpAttachment(
    name: String,
    block: suspend StaticIpAttachmentResourceBuilder.() -> Unit,
): StaticIpAttachment {
    val builder = StaticIpAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StaticIpAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun staticIpAttachment(name: String): StaticIpAttachment {
    val builder = StaticIpAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
