@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.StaticIpAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a static IP address attachment - relationship between a Lightsail static IP & Lightsail instance.
 * > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail) for more details
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testStaticIp = new aws.lightsail.StaticIp("test", {name: "example"});
 * const testInstance = new aws.lightsail.Instance("test", {
 *     name: "example",
 *     availabilityZone: "us-east-1b",
 *     blueprintId: "string",
 *     bundleId: "string",
 *     keyPairName: "some_key_name",
 * });
 * const test = new aws.lightsail.StaticIpAttachment("test", {
 *     staticIpName: testStaticIp.id,
 *     instanceName: testInstance.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_static_ip = aws.lightsail.StaticIp("test", name="example")
 * test_instance = aws.lightsail.Instance("test",
 *     name="example",
 *     availability_zone="us-east-1b",
 *     blueprint_id="string",
 *     bundle_id="string",
 *     key_pair_name="some_key_name")
 * test = aws.lightsail.StaticIpAttachment("test",
 *     static_ip_name=test_static_ip.id,
 *     instance_name=test_instance.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testStaticIp = new Aws.LightSail.StaticIp("test", new()
 *     {
 *         Name = "example",
 *     });
 *     var testInstance = new Aws.LightSail.Instance("test", new()
 *     {
 *         Name = "example",
 *         AvailabilityZone = "us-east-1b",
 *         BlueprintId = "string",
 *         BundleId = "string",
 *         KeyPairName = "some_key_name",
 *     });
 *     var test = new Aws.LightSail.StaticIpAttachment("test", new()
 *     {
 *         StaticIpName = testStaticIp.Id,
 *         InstanceName = testInstance.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lightsail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		testStaticIp, err := lightsail.NewStaticIp(ctx, "test", &lightsail.StaticIpArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testInstance, err := lightsail.NewInstance(ctx, "test", &lightsail.InstanceArgs{
 * 			Name:             pulumi.String("example"),
 * 			AvailabilityZone: pulumi.String("us-east-1b"),
 * 			BlueprintId:      pulumi.String("string"),
 * 			BundleId:         pulumi.String("string"),
 * 			KeyPairName:      pulumi.String("some_key_name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lightsail.NewStaticIpAttachment(ctx, "test", &lightsail.StaticIpAttachmentArgs{
 * 			StaticIpName: testStaticIp.ID(),
 * 			InstanceName: testInstance.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.StaticIp;
 * import com.pulumi.aws.lightsail.StaticIpArgs;
 * import com.pulumi.aws.lightsail.Instance;
 * import com.pulumi.aws.lightsail.InstanceArgs;
 * import com.pulumi.aws.lightsail.StaticIpAttachment;
 * import com.pulumi.aws.lightsail.StaticIpAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testStaticIp = new StaticIp("testStaticIp", StaticIpArgs.builder()
 *             .name("example")
 *             .build());
 *         var testInstance = new Instance("testInstance", InstanceArgs.builder()
 *             .name("example")
 *             .availabilityZone("us-east-1b")
 *             .blueprintId("string")
 *             .bundleId("string")
 *             .keyPairName("some_key_name")
 *             .build());
 *         var test = new StaticIpAttachment("test", StaticIpAttachmentArgs.builder()
 *             .staticIpName(testStaticIp.id())
 *             .instanceName(testInstance.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:lightsail:StaticIpAttachment
 *     properties:
 *       staticIpName: ${testStaticIp.id}
 *       instanceName: ${testInstance.id}
 *   testStaticIp:
 *     type: aws:lightsail:StaticIp
 *     name: test
 *     properties:
 *       name: example
 *   testInstance:
 *     type: aws:lightsail:Instance
 *     name: test
 *     properties:
 *       name: example
 *       availabilityZone: us-east-1b
 *       blueprintId: string
 *       bundleId: string
 *       keyPairName: some_key_name
 * ```
 * <!--End PulumiCodeChooser -->
 * @property instanceName The name of the Lightsail instance to attach the IP to
 * @property staticIpName The name of the allocated static IP
 */
public data class StaticIpAttachmentArgs(
    public val instanceName: Output<String>? = null,
    public val staticIpName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.StaticIpAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.StaticIpAttachmentArgs =
        com.pulumi.aws.lightsail.StaticIpAttachmentArgs.builder()
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .staticIpName(staticIpName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StaticIpAttachmentArgs].
 */
@PulumiTagMarker
public class StaticIpAttachmentArgsBuilder internal constructor() {
    private var instanceName: Output<String>? = null

    private var staticIpName: Output<String>? = null

    /**
     * @param value The name of the Lightsail instance to attach the IP to
     */
    @JvmName("vxkolaagxstbxdxn")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value The name of the allocated static IP
     */
    @JvmName("clbhswietwbcurnf")
    public suspend fun staticIpName(`value`: Output<String>) {
        this.staticIpName = value
    }

    /**
     * @param value The name of the Lightsail instance to attach the IP to
     */
    @JvmName("hewdmwdkkilcdpjs")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value The name of the allocated static IP
     */
    @JvmName("mdinxoyhqvysmydk")
    public suspend fun staticIpName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.staticIpName = mapped
    }

    internal fun build(): StaticIpAttachmentArgs = StaticIpAttachmentArgs(
        instanceName = instanceName,
        staticIpName = staticIpName,
    )
}
