@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.inputs

import com.pulumi.aws.lightsail.inputs.ContainerServiceDeploymentVersionContainerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property commands The launch command for the container. A list of string.
 * @property containerName The name for the container.
 * @property environment A key-value map of the environment variables of the container.
 * @property image The name of the image used for the container. Container images sourced from your Lightsail container service, that are registered and stored on your service, start with a colon (`:`). For example, `:container-service-1.mystaticwebsite.1`. Container images sourced from a public registry like Docker Hub don't start with a colon. For example, `nginx:latest` or `nginx`.
 * @property ports A key-value map of the open firewall ports of the container. Valid values: `HTTP`, `HTTPS`, `TCP`, `UDP`.
 */
public data class ContainerServiceDeploymentVersionContainerArgs(
    public val commands: Output<List<String>>? = null,
    public val containerName: Output<String>,
    public val environment: Output<Map<String, String>>? = null,
    public val image: Output<String>,
    public val ports: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.lightsail.inputs.ContainerServiceDeploymentVersionContainerArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.inputs.ContainerServiceDeploymentVersionContainerArgs =
        com.pulumi.aws.lightsail.inputs.ContainerServiceDeploymentVersionContainerArgs.builder()
            .commands(commands?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .containerName(containerName.applyValue({ args0 -> args0 }))
            .environment(
                environment?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .image(image.applyValue({ args0 -> args0 }))
            .ports(
                ports?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ContainerServiceDeploymentVersionContainerArgs].
 */
@PulumiTagMarker
public class ContainerServiceDeploymentVersionContainerArgsBuilder internal constructor() {
    private var commands: Output<List<String>>? = null

    private var containerName: Output<String>? = null

    private var environment: Output<Map<String, String>>? = null

    private var image: Output<String>? = null

    private var ports: Output<Map<String, String>>? = null

    /**
     * @param value The launch command for the container. A list of string.
     */
    @JvmName("camxpaidekbnrjol")
    public suspend fun commands(`value`: Output<List<String>>) {
        this.commands = value
    }

    @JvmName("fsxfxeruvrulkgsu")
    public suspend fun commands(vararg values: Output<String>) {
        this.commands = Output.all(values.asList())
    }

    /**
     * @param values The launch command for the container. A list of string.
     */
    @JvmName("xtwaixmitbsxloig")
    public suspend fun commands(values: List<Output<String>>) {
        this.commands = Output.all(values)
    }

    /**
     * @param value The name for the container.
     */
    @JvmName("gcislspmwbxjaaat")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value A key-value map of the environment variables of the container.
     */
    @JvmName("yivoevbowsxocpqv")
    public suspend fun environment(`value`: Output<Map<String, String>>) {
        this.environment = value
    }

    /**
     * @param value The name of the image used for the container. Container images sourced from your Lightsail container service, that are registered and stored on your service, start with a colon (`:`). For example, `:container-service-1.mystaticwebsite.1`. Container images sourced from a public registry like Docker Hub don't start with a colon. For example, `nginx:latest` or `nginx`.
     */
    @JvmName("kdtogjxqdbtiggyv")
    public suspend fun image(`value`: Output<String>) {
        this.image = value
    }

    /**
     * @param value A key-value map of the open firewall ports of the container. Valid values: `HTTP`, `HTTPS`, `TCP`, `UDP`.
     */
    @JvmName("xjgkhvqabsmhmrqs")
    public suspend fun ports(`value`: Output<Map<String, String>>) {
        this.ports = value
    }

    /**
     * @param value The launch command for the container. A list of string.
     */
    @JvmName("miynhmfltqguejda")
    public suspend fun commands(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param values The launch command for the container. A list of string.
     */
    @JvmName("irfsvaxrernbriiv")
    public suspend fun commands(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param value The name for the container.
     */
    @JvmName("nhytwedgdrgreboy")
    public suspend fun containerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value A key-value map of the environment variables of the container.
     */
    @JvmName("rmtkjqeunkujepqt")
    public suspend fun environment(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environment = mapped
    }

    /**
     * @param values A key-value map of the environment variables of the container.
     */
    @JvmName("tvnwuegpdtgranpt")
    public fun environment(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environment = mapped
    }

    /**
     * @param value The name of the image used for the container. Container images sourced from your Lightsail container service, that are registered and stored on your service, start with a colon (`:`). For example, `:container-service-1.mystaticwebsite.1`. Container images sourced from a public registry like Docker Hub don't start with a colon. For example, `nginx:latest` or `nginx`.
     */
    @JvmName("tvkkifaadfpqidfb")
    public suspend fun image(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param value A key-value map of the open firewall ports of the container. Valid values: `HTTP`, `HTTPS`, `TCP`, `UDP`.
     */
    @JvmName("yqrjahekbdpihjrl")
    public suspend fun ports(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    /**
     * @param values A key-value map of the open firewall ports of the container. Valid values: `HTTP`, `HTTPS`, `TCP`, `UDP`.
     */
    @JvmName("jrxdrljjggjawfxj")
    public fun ports(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    internal fun build(): ContainerServiceDeploymentVersionContainerArgs =
        ContainerServiceDeploymentVersionContainerArgs(
            commands = commands,
            containerName = containerName ?: throw PulumiNullFieldException("containerName"),
            environment = environment,
            image = image ?: throw PulumiNullFieldException("image"),
            ports = ports,
        )
}
