@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.inputs

import com.pulumi.aws.lightsail.inputs.ContainerServiceDeploymentVersionPublicEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property containerName The name of the container for the endpoint.
 * @property containerPort The port of the container to which traffic is forwarded to.
 * @property healthCheck A configuration block that describes the health check configuration of the container. Detailed below.
 */
public data class ContainerServiceDeploymentVersionPublicEndpointArgs(
    public val containerName: Output<String>,
    public val containerPort: Output<Int>,
    public val healthCheck: Output<ContainerServiceDeploymentVersionPublicEndpointHealthCheckArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.lightsail.inputs.ContainerServiceDeploymentVersionPublicEndpointArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.inputs.ContainerServiceDeploymentVersionPublicEndpointArgs =
        com.pulumi.aws.lightsail.inputs.ContainerServiceDeploymentVersionPublicEndpointArgs.builder()
            .containerName(containerName.applyValue({ args0 -> args0 }))
            .containerPort(containerPort.applyValue({ args0 -> args0 }))
            .healthCheck(healthCheck.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ContainerServiceDeploymentVersionPublicEndpointArgs].
 */
@PulumiTagMarker
public class ContainerServiceDeploymentVersionPublicEndpointArgsBuilder internal constructor() {
    private var containerName: Output<String>? = null

    private var containerPort: Output<Int>? = null

    private var healthCheck: Output<ContainerServiceDeploymentVersionPublicEndpointHealthCheckArgs>? =
        null

    /**
     * @param value The name of the container for the endpoint.
     */
    @JvmName("wdgpwmcqipulileu")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value The port of the container to which traffic is forwarded to.
     */
    @JvmName("fxlqkdrjnlnmppwt")
    public suspend fun containerPort(`value`: Output<Int>) {
        this.containerPort = value
    }

    /**
     * @param value A configuration block that describes the health check configuration of the container. Detailed below.
     */
    @JvmName("pexvfampqrhygqmf")
    public suspend fun healthCheck(`value`: Output<ContainerServiceDeploymentVersionPublicEndpointHealthCheckArgs>) {
        this.healthCheck = value
    }

    /**
     * @param value The name of the container for the endpoint.
     */
    @JvmName("jkvcphlsrycimjkc")
    public suspend fun containerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value The port of the container to which traffic is forwarded to.
     */
    @JvmName("bxewgyvatrohhbps")
    public suspend fun containerPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerPort = mapped
    }

    /**
     * @param value A configuration block that describes the health check configuration of the container. Detailed below.
     */
    @JvmName("oqnhmpvtchrgsbrh")
    public suspend fun healthCheck(`value`: ContainerServiceDeploymentVersionPublicEndpointHealthCheckArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.healthCheck = mapped
    }

    /**
     * @param argument A configuration block that describes the health check configuration of the container. Detailed below.
     */
    @JvmName("dwymeaomgerddwrw")
    public suspend fun healthCheck(argument: suspend ContainerServiceDeploymentVersionPublicEndpointHealthCheckArgsBuilder.() -> Unit) {
        val toBeMapped =
            ContainerServiceDeploymentVersionPublicEndpointHealthCheckArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.healthCheck = mapped
    }

    internal fun build(): ContainerServiceDeploymentVersionPublicEndpointArgs =
        ContainerServiceDeploymentVersionPublicEndpointArgs(
            containerName = containerName ?: throw PulumiNullFieldException("containerName"),
            containerPort = containerPort ?: throw PulumiNullFieldException("containerPort"),
            healthCheck = healthCheck ?: throw PulumiNullFieldException("healthCheck"),
        )
}
