@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin.inputs

import com.pulumi.aws.lightsail.inputs.ContainerServicePrivateRegistryAccessArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property ecrImagePullerRole Describes a request to configure an Amazon Lightsail container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See ECR Image Puller Role below for more details.
 */
public data class ContainerServicePrivateRegistryAccessArgs(
    public val ecrImagePullerRole: Output<ContainerServicePrivateRegistryAccessEcrImagePullerRoleArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.inputs.ContainerServicePrivateRegistryAccessArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.inputs.ContainerServicePrivateRegistryAccessArgs =
        com.pulumi.aws.lightsail.inputs.ContainerServicePrivateRegistryAccessArgs.builder()
            .ecrImagePullerRole(
                ecrImagePullerRole?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ContainerServicePrivateRegistryAccessArgs].
 */
@PulumiTagMarker
public class ContainerServicePrivateRegistryAccessArgsBuilder internal constructor() {
    private var ecrImagePullerRole:
        Output<ContainerServicePrivateRegistryAccessEcrImagePullerRoleArgs>? = null

    /**
     * @param value Describes a request to configure an Amazon Lightsail container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See ECR Image Puller Role below for more details.
     */
    @JvmName("mhknvriedcjeyfjf")
    public suspend fun ecrImagePullerRole(`value`: Output<ContainerServicePrivateRegistryAccessEcrImagePullerRoleArgs>) {
        this.ecrImagePullerRole = value
    }

    /**
     * @param value Describes a request to configure an Amazon Lightsail container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See ECR Image Puller Role below for more details.
     */
    @JvmName("punbtshvfriondyk")
    public suspend fun ecrImagePullerRole(`value`: ContainerServicePrivateRegistryAccessEcrImagePullerRoleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecrImagePullerRole = mapped
    }

    /**
     * @param argument Describes a request to configure an Amazon Lightsail container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See ECR Image Puller Role below for more details.
     */
    @JvmName("nnhcajpfexnadxlf")
    public suspend fun ecrImagePullerRole(argument: suspend ContainerServicePrivateRegistryAccessEcrImagePullerRoleArgsBuilder.() -> Unit) {
        val toBeMapped =
            ContainerServicePrivateRegistryAccessEcrImagePullerRoleArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ecrImagePullerRole = mapped
    }

    internal fun build(): ContainerServicePrivateRegistryAccessArgs =
        ContainerServicePrivateRegistryAccessArgs(
            ecrImagePullerRole = ecrImagePullerRole,
        )
}
